/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import java.util.List;
import org.eclipse.cft.server.core.CFServiceInstance;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.ServerEventHandler;
import org.eclipse.cft.server.core.internal.client.BaseClientRequest;
import org.eclipse.cft.server.core.internal.client.CFOperation;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.springframework.web.client.HttpServerErrorException;

public class UpdateServicesOperation
extends CFOperation {
    private final BaseClientRequest<List<CFServiceInstance>> request;

    public UpdateServicesOperation(BaseClientRequest<List<CFServiceInstance>> request, CloudFoundryServerBehaviour behaviour) {
        super(behaviour);
        this.request = request;
    }

    @Override
    public String getOperationName() {
        return Messages.UpdateServicesOperation_OPERATION_MESSAGE;
    }

    @Override
    public void run(IProgressMonitor monitor) throws CoreException {
        try {
            List<CFServiceInstance> existingServices = this.request.run(monitor);
            ServerEventHandler.getDefault().fireServicesUpdated(this.getBehaviour().getCloudFoundryServer(), existingServices);
        }
        catch (CoreException e) {
            CoreException rethrow = e;
            if (e.getCause() instanceof HttpServerErrorException) {
                HttpServerErrorException hsee = (HttpServerErrorException)e.getCause();
                ServiceCreationFailedException scfe = new ServiceCreationFailedException(hsee.getStatusCode() + " " + hsee.getStatusCode().getReasonPhrase(), (Exception)hsee);
                Status newStatus = new Status(e.getStatus().getSeverity(), e.getStatus().getPlugin(), e.getStatus().getCode(), hsee.getMessage(), (Throwable)scfe);
                rethrow = new CoreException((IStatus)newStatus);
            }
            this.logNonModuleError(rethrow);
            throw rethrow;
        }
    }

    @Override
    protected boolean shouldLogException(CoreException e) {
        return !CloudErrorUtil.isNotFoundException(e);
    }

    public static class ServiceCreationFailedException
    extends Exception {
        public ServiceCreationFailedException(String message, Exception cause) {
            super(message, cause);
        }
    }
}

