/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.spaces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.client.lib.domain.CloudOrganization;
import org.cloudfoundry.client.lib.domain.CloudSpace;

public class CloudOrgsAndSpaces {
    private final List<CloudSpace> originalSpaces;
    private Map<String, List<CloudSpace>> orgIDtoSpaces;
    private Map<String, CloudOrganization> orgIDtoOrg;

    public CloudOrgsAndSpaces(List<CloudSpace> spaces) {
        this.originalSpaces = spaces;
        this.setValues();
    }

    public CloudSpace getSpace(String orgName, String spaceName) {
        List<CloudSpace> oSpaces = this.orgIDtoSpaces.get(orgName);
        if (oSpaces != null) {
            for (CloudSpace clSpace : oSpaces) {
                if (!clSpace.getName().equals(spaceName)) continue;
                return clSpace;
            }
        }
        return null;
    }

    public List<CloudOrganization> getOrgs() {
        Collection<CloudOrganization> orgList = this.orgIDtoOrg.values();
        return new ArrayList<CloudOrganization>(orgList);
    }

    protected void setValues() {
        this.orgIDtoSpaces = new HashMap<String, List<CloudSpace>>();
        this.orgIDtoOrg = new HashMap<String, CloudOrganization>();
        for (CloudSpace clSpace : this.originalSpaces) {
            CloudOrganization org = clSpace.getOrganization();
            List<CloudSpace> spaces = this.orgIDtoSpaces.get(org.getName());
            if (spaces == null) {
                spaces = new ArrayList<CloudSpace>();
                this.orgIDtoSpaces.put(org.getName(), spaces);
                this.orgIDtoOrg.put(org.getName(), org);
            }
            spaces.add(clSpace);
        }
    }

    public List<CloudSpace> getOrgSpaces(String orgName) {
        return this.orgIDtoSpaces.get(orgName);
    }

    public CloudSpace getDefaultCloudSpace() {
        if (this.originalSpaces != null && this.originalSpaces.size() > 0) {
            return this.originalSpaces.get(0);
        }
        return null;
    }

    public List<CloudSpace> getAllSpaces() {
        return this.originalSpaces != null ? new ArrayList<CloudSpace>(this.originalSpaces) : new ArrayList(0);
    }
}

