/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.application;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cft.server.core.AbstractApplicationDelegate;
import org.eclipse.cft.server.core.internal.application.ApplicationRegistry;
import org.eclipse.cft.server.core.internal.application.FrameworkProvider;
import org.eclipse.core.runtime.IConfigurationElement;

public class ApplicationProvider
extends FrameworkProvider<AbstractApplicationDelegate> {
    private static final String MODULE_ID_ELEMENT = "moduleID";
    private static final String PRIORITY_ATTR = "priority";
    private static final String ID_ATTRIBUTE = "id";
    private ApplicationRegistry.Priority priority;
    private List<String> moduleIDs;

    public ApplicationProvider(IConfigurationElement configurationElement, String extensionPointID) {
        super(configurationElement, extensionPointID);
    }

    public ApplicationRegistry.Priority getPriority() {
        if (this.priority == null && this.configurationElement != null) {
            this.priority = ApplicationProvider.getPriority(this.configurationElement.getAttribute(PRIORITY_ATTR));
        }
        return this.priority;
    }

    public List<String> getModuleIDs() {
        if (this.moduleIDs == null) {
            IConfigurationElement[] moduleIDElements;
            this.moduleIDs = new ArrayList<String>();
            if (this.configurationElement != null && (moduleIDElements = this.configurationElement.getChildren(MODULE_ID_ELEMENT)) != null) {
                IConfigurationElement[] iConfigurationElementArray = moduleIDElements;
                int n = moduleIDElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    String value = element.getAttribute(ID_ATTRIBUTE);
                    if (value != null) {
                        this.moduleIDs.add(value);
                    }
                    ++n2;
                }
            }
        }
        return this.moduleIDs;
    }

    private static ApplicationRegistry.Priority getPriority(String priority) {
        ApplicationRegistry.Priority[] priorityArray = ApplicationRegistry.Priority.values();
        int n = priorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            ApplicationRegistry.Priority pr = priorityArray[n2];
            if (pr.name().equals(priority)) {
                return pr;
            }
            ++n2;
        }
        return null;
    }
}

