/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cft.server.core.AbstractApplicationDelegate;
import org.eclipse.cft.server.core.internal.ApplicationAction;
import org.eclipse.cft.server.core.internal.ApplicationUrlLookupService;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.ValueValidationUtil;
import org.eclipse.cft.server.core.internal.application.ApplicationRegistry;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.ui.internal.CloudApplicationUrlPart;
import org.eclipse.cft.server.ui.internal.CloudFoundryImages;
import org.eclipse.cft.server.ui.internal.IEventSource;
import org.eclipse.cft.server.ui.internal.Logger;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.PartChangeEvent;
import org.eclipse.cft.server.ui.internal.UIPart;
import org.eclipse.cft.server.ui.internal.WizardPartChangeEvent;
import org.eclipse.cft.server.ui.internal.wizards.AbstractURLWizardPage;
import org.eclipse.cft.server.ui.internal.wizards.ApplicationWizardDelegate;
import org.eclipse.cft.server.ui.internal.wizards.ApplicationWizardDescriptor;
import org.eclipse.cft.server.ui.internal.wizards.CloudFoundryApplicationWizard;
import org.eclipse.cft.server.ui.internal.wizards.CloudUIEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CloudFoundryDeploymentWizardPage
extends AbstractURLWizardPage
implements Observer {
    protected final String serverTypeId;
    protected final CloudFoundryServer server;
    protected Composite runDebugOptions;
    protected Button regularStartOnDeploymentButton;
    protected CloudFoundryApplicationWizard wizard;
    protected final CloudFoundryApplicationModule module;
    protected final ApplicationWizardDescriptor descriptor;
    protected CloudApplicationUrlPart urlPart;
    private MemoryPart memoryPart;
    private static final String DEFAULT_MEMORY = "512";
    private ApplicationWizardDelegate wizardDelegate;

    public CloudFoundryDeploymentWizardPage(CloudFoundryServer server, CloudFoundryApplicationModule module, ApplicationWizardDescriptor descriptor, ApplicationUrlLookupService urlLookup, ApplicationWizardDelegate wizardDelegate) {
        super(Messages.CloudFoundryDeploymentWizardPage_TEXT_DEPLOYMENT, null, null);
        this.server = server;
        this.module = module;
        this.descriptor = descriptor;
        this.serverTypeId = module.getServerTypeId();
        this.urlPart = this.createUrlPart(urlLookup);
        this.urlPart.setPage((IWizardPage)this);
        this.urlPart.addPartChangeListener(this);
        this.wizardDelegate = wizardDelegate;
        descriptor.getDeploymentInfo().addObserver((Observer)this);
    }

    @Override
    protected void performWhenPageVisible() {
        this.refreshMemoryOptions();
    }

    protected void refreshMemoryOptions() {
        this.memoryPart.refreshMemoryOptions();
    }

    protected Point getRunDebugControlIndentation() {
        return new Point(15, 5);
    }

    protected void setMemory(String memoryVal) {
        int memory = -1;
        try {
            memory = Integer.parseInt(memoryVal);
        }
        catch (NumberFormatException numberFormatException) {}
        IStatus status = Status.OK_STATUS;
        if (memory > 0) {
            this.descriptor.getDeploymentInfo().setMemory(memory);
        } else {
            this.descriptor.getDeploymentInfo().setMemory(-1);
            status = CloudFoundryPlugin.getErrorStatus((String)Messages.ERROR_INVALID_MEMORY);
        }
        this.handleChange(new PartChangeEvent(memoryVal, status, CloudUIEvent.MEMORY));
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.CloudFoundryDeploymentWizardPage_TITLE_LAUNCH_DEPLOY);
        this.setDescription(Messages.CloudFoundryDeploymentWizardPage_TEXT_DEPLOY_DETAIL);
        ImageDescriptor banner = CloudFoundryImages.getWizardBanner(this.serverTypeId);
        if (banner != null) {
            this.setImageDescriptor(banner);
        }
        this.wizard = (CloudFoundryApplicationWizard)this.getWizard();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createAreas(composite);
        this.setControl((Control)composite);
    }

    protected void createAreas(Composite parent) {
        Composite topComposite = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout(2, false);
        topComposite.setLayout((Layout)topLayout);
        topComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createURLArea(topComposite);
        this.createMemoryArea(topComposite);
        this.createStartOrDebugOptions(parent);
    }

    protected void createURLArea(Composite parent) {
        this.urlPart.createPart(parent);
        this.urlPart.refreshDomains();
        this.updateApplicationURL();
    }

    protected CloudApplicationUrlPart createUrlPart(ApplicationUrlLookupService urlLookup) {
        return new CloudApplicationUrlPart(urlLookup);
    }

    protected void createMemoryArea(Composite parent) {
        this.memoryPart = new MemoryPart();
        this.memoryPart.addPartChangeListener(this);
        this.memoryPart.createPart(parent);
    }

    protected void createStartOrDebugOptions(Composite parent) {
        String startLabelText = Messages.CloudFoundryDeploymentWizardPage_LABEL_START_APP;
        this.regularStartOnDeploymentButton = new Button(parent, 32);
        this.regularStartOnDeploymentButton.setText(startLabelText);
        ApplicationAction deploymentMode = this.descriptor.getApplicationStartMode();
        this.regularStartOnDeploymentButton.setSelection(deploymentMode == ApplicationAction.START);
        GridData buttonData = new GridData(4, 4, false, false);
        if (!this.isServerDebugModeAllowed()) {
            buttonData.horizontalSpan = 2;
            buttonData.verticalIndent = 10;
        }
        this.regularStartOnDeploymentButton.setLayoutData((Object)buttonData);
        this.regularStartOnDeploymentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean start = CloudFoundryDeploymentWizardPage.this.regularStartOnDeploymentButton.getSelection();
                ApplicationAction deploymentMode = null;
                deploymentMode = start ? ApplicationAction.START : ApplicationAction.STOP;
                CloudFoundryDeploymentWizardPage.this.descriptor.setApplicationStartMode(deploymentMode);
            }
        });
    }

    protected boolean isServerDebugModeAllowed() {
        return false;
    }

    protected void makeStartDeploymentControlsVisible(boolean makeVisible) {
        if (this.runDebugOptions != null && !this.runDebugOptions.isDisposed()) {
            GridData data = (GridData)this.runDebugOptions.getLayoutData();
            GridDataFactory.createFrom((GridData)data).exclude(!makeVisible).applyTo((Control)this.runDebugOptions);
            this.runDebugOptions.setVisible(makeVisible);
            this.runDebugOptions.getParent().layout(true, true);
        }
    }

    protected void setUrlInDescriptor(String url) {
        if (url != null) {
            ArrayList<String> urls = new ArrayList<String>();
            urls.add(url);
            this.descriptor.getDeploymentInfo().setUris(urls);
        } else {
            this.descriptor.getDeploymentInfo().setUris(null);
        }
    }

    @Override
    public void handleChange(PartChangeEvent event) {
        Object eventData = event.getData();
        IEventSource<?> source = event.getSource();
        if (event.getSource() == CloudUIEvent.APPLICATION_URL_CHANGED) {
            String urlVal = eventData instanceof String ? (String)eventData : null;
            this.setUrlInDescriptor(urlVal);
            IStatus status = event.getStatus();
            if (ValueValidationUtil.isEmpty((String)urlVal) && !this.requiresUrl()) {
                status = Status.OK_STATUS;
            }
            event = new WizardPartChangeEvent(eventData, status, event.getSource(), true);
        } else if (source == CloudUIEvent.APP_NAME_CHANGE_EVENT) {
            String value = (String)event.getData();
            this.updateApplicationNameInDescriptor(value);
            this.updateApplicationURLFromAppName();
        }
        super.handleChange(event);
    }

    protected void updateApplicationNameInDescriptor(String appName) {
        if (ValueValidationUtil.isEmpty((String)appName)) {
            appName = null;
        }
        this.descriptor.getDeploymentInfo().setDeploymentName(appName);
    }

    protected void updateApplicationURL() {
        String url;
        List urls = this.descriptor.getDeploymentInfo().getUris();
        String string = url = urls != null && !urls.isEmpty() ? (String)urls.get(0) : null;
        if (url != null) {
            this.urlPart.setUrl(url);
        } else {
            this.updateApplicationURLFromAppName();
        }
    }

    protected void updateApplicationURLFromAppName() {
        if (this.shouldSetDefaultUrl()) {
            String appName = this.descriptor.getDeploymentInfo().getDeploymentName();
            this.urlPart.setSubdomain(appName);
        }
    }

    protected boolean requiresUrl() {
        return this.wizardDelegate == null || this.wizardDelegate.getApplicationDelegate() == null || this.wizardDelegate.getApplicationDelegate().requiresURL();
    }

    protected boolean shouldSetDefaultUrl() {
        return this.wizardDelegate == null || ApplicationRegistry.shouldSetDefaultUrl((AbstractApplicationDelegate)this.wizardDelegate.getApplicationDelegate(), (CloudFoundryApplicationModule)this.module);
    }

    @Override
    protected void domainsRefreshed() {
        this.urlPart.refreshDomains();
        this.updateApplicationURL();
    }

    @Override
    public void update(Observable o, Object arg) {
        block3: {
            if (arg != null && arg instanceof String) {
                try {
                    this.updateApplicationURLFromAppName();
                }
                catch (Exception e) {
                    if (!Logger.ERROR) break block3;
                    Logger.println("/debug/error", this, "update", "Error updating Application name", (Throwable)e);
                }
            }
        }
    }

    class MemoryPart
    extends UIPart {
        protected Text memory;

        MemoryPart() {
        }

        @Override
        public Control createPart(Composite parent) {
            Label label = new Label(parent, 0);
            label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            label.setText(Messages.LABEL_MEMORY_LIMIT);
            this.memory = new Text(parent, 2048);
            this.memory.setLayoutData((Object)new GridData(4, 4, true, false));
            GridData gd = new GridData(4, 4, true, false);
            gd.horizontalSpan = 2;
            this.memory.setLayoutData((Object)gd);
            this.memory.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CloudFoundryDeploymentWizardPage.this.setMemory(MemoryPart.this.memory.getText());
                }
            });
            return parent;
        }

        public void refreshMemoryOptions() {
            if (this.memory != null && !this.memory.isDisposed()) {
                int currentMemory = CloudFoundryDeploymentWizardPage.this.descriptor.getDeploymentInfo().getMemory();
                if (currentMemory <= 0) {
                    this.memory.setText(CloudFoundryDeploymentWizardPage.DEFAULT_MEMORY);
                } else {
                    this.memory.setText(String.valueOf(currentMemory));
                }
            }
        }
    }
}

