/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.sunburst.view;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.capra.core.adapters.TraceMetaModelAdapter;
import org.eclipse.capra.core.adapters.TracePersistenceAdapter;
import org.eclipse.capra.core.handlers.IArtifactHandler;
import org.eclipse.capra.core.handlers.IArtifactUnpacker;
import org.eclipse.capra.core.helpers.ArtifactHelper;
import org.eclipse.capra.core.helpers.EMFHelper;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.core.helpers.TraceHelper;
import org.eclipse.capra.ui.helpers.SelectionSupportHelper;
import org.eclipse.capra.ui.sunburst.SunburstPreferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.osgi.service.prefs.BackingStoreException;

public class SunburstView
extends ViewPart {
    private static final String HTML_SOURCE_LOCATION = "platform:/plugin/org.eclipse.capra.ui.sunburst/src/html/index.html";
    private int maxRecursionLevel;
    IEclipsePreferences preferences = SunburstPreferences.getPreferences();
    private Browser browser;
    private Action selectDepthAction;
    private final TraceMetaModelAdapter traceAdapter = (TraceMetaModelAdapter)ExtensionPointHelper.getTraceMetamodelAdapter().orElseThrow();
    private final TracePersistenceAdapter persistenceAdapter = (TracePersistenceAdapter)ExtensionPointHelper.getTracePersistenceAdapter().orElseThrow();
    private ResourceSet resourceSet = EditingDomainHelper.getResourceSet();
    private EObject traceModel = this.persistenceAdapter.getTraceModel(this.resourceSet);
    private EObject artifactModel = this.persistenceAdapter.getArtifactWrappers(this.resourceSet);
    private ArtifactHelper artifactHelper = new ArtifactHelper(this.artifactModel);
    private TraceHelper traceHelper = new TraceHelper(this.traceModel);
    private List<Object> selectedModels = new ArrayList<Object>();
    private Listener redrawListener = new Listener(){

        public void handleEvent(Event event) {
            SunburstView.this.browser.setText(SunburstView.this.createHTML());
        }
    };
    private ISelectionListener listener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            this.getSelected(part, selection);
            SunburstView.this.browser.setText(SunburstView.this.createHTML());
        }

        private void getSelected(IWorkbenchPart part, ISelection selection) {
            SunburstView.this.selectedModels.clear();
            if (part.getSite().getSelectionProvider() != null) {
                SunburstView.this.selectedModels.addAll(SelectionSupportHelper.extractSelectedElements((ISelection)part.getSite().getSelectionProvider().getSelection(), (IWorkbenchPart)part));
            }
        }
    };

    public void createPartControl(Composite parent) {
        this.maxRecursionLevel = this.preferences.getInt("MAX_RECURSION_LEVEL", 5);
        this.browser = new Browser(parent, 0);
        this.browser.setText(this.createHTML());
        this.makeActions();
        this.contributeToActionBars();
        this.getViewSite().getPage().addSelectionListener(this.listener);
        parent.addListener(11, this.redrawListener);
    }

    public void dispose() {
        this.getViewSite().getPage().removeSelectionListener(this.listener);
        this.browser.dispose();
        this.browser = null;
        super.dispose();
    }

    public void setFocus() {
    }

    private void makeActions() {
        this.selectDepthAction = new SelectDepthAction();
        this.selectDepthAction.setText("Set recursion depth...");
        this.selectDepthAction.setToolTipText("Select the maximum depth until which traceability links will be traversed.");
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.removeAll();
        manager.add((IAction)this.selectDepthAction);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
    }

    private String getHTML() {
        StringBuilder html = new StringBuilder();
        try {
            String inputLine;
            URL url = new URL(HTML_SOURCE_LOCATION);
            InputStream inputStream = url.openConnection().getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
            while ((inputLine = in.readLine()) != null) {
                html.append(inputLine);
                html.append(System.lineSeparator());
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return html.toString();
    }

    private String createHTML() {
        String json = this.convertToJSON();
        String html = this.getHTML();
        return html.replace("const nodeData;", "const nodeData = " + json + ";");
    }

    private String convertToJSON() {
        List<EObject> secondLevelNodes = new ArrayList<EObject>();
        String start = "";
        String end = "]}";
        StringBuilder inner = new StringBuilder();
        ArrayList<EObject> alreadySeen = new ArrayList<EObject>();
        if (!this.selectedModels.isEmpty()) {
            for (Object selection : this.selectedModels) {
                IArtifactHandler handler = this.artifactHelper.getHandler(selection).orElse(null);
                if (handler == null) continue;
                Object unpackedElement = null;
                unpackedElement = handler instanceof IArtifactUnpacker ? ((IArtifactUnpacker)IArtifactUnpacker.class.cast(handler)).unpack(selection) : selection;
                EObject wrappedElement = handler.createWrapper(unpackedElement, this.artifactModel);
                if (!this.traceHelper.isArtifactInTraceModel(wrappedElement)) continue;
                EObject selectedObject = wrappedElement;
                if (this.selectedModels.size() == 1) {
                    secondLevelNodes = this.getUniqueChildren(null, selectedObject);
                    start = "{\"name\": \"" + this.artifactHelper.getArtifactLabel(selectedObject) + "\",\"children\":[";
                    alreadySeen.add(selectedObject);
                    continue;
                }
                start = "{\"name\":\"\",\"children\":[";
                secondLevelNodes.add(selectedObject);
            }
        }
        int secondLevelIndex = 0;
        while (secondLevelIndex < secondLevelNodes.size()) {
            this.processHierarchyLevel(inner, (EObject)secondLevelNodes.get(secondLevelIndex), alreadySeen, 1);
            if (secondLevelIndex < secondLevelNodes.size() - 1) {
                inner.append(",");
            }
            ++secondLevelIndex;
        }
        return String.valueOf(start) + inner.toString() + end;
    }

    private void processHierarchyLevel(StringBuilder builder, EObject parent, List<EObject> alreadySeen, int currentLevel) {
        if (alreadySeen == null) {
            alreadySeen = new ArrayList<EObject>();
        }
        String text = this.artifactHelper.getArtifactLabel(parent);
        this.getEntryJSON(builder, text);
        alreadySeen.add(parent);
        if (currentLevel < this.maxRecursionLevel) {
            List<EObject> children = this.getUniqueChildren(alreadySeen, parent);
            if (!children.isEmpty()) {
                builder.append("\"children\":[");
                int childLevelIndex = 0;
                while (childLevelIndex < children.size()) {
                    this.processHierarchyLevel(builder, children.get(childLevelIndex), alreadySeen, currentLevel + 1);
                    alreadySeen.remove(children.get(childLevelIndex));
                    if (childLevelIndex < children.size() - 1) {
                        builder.append(",");
                    }
                    ++childLevelIndex;
                }
                builder.append("]}");
            } else {
                builder.append("\"size\": 1}");
            }
        } else {
            builder.append("\"size\": 1}");
        }
    }

    private void getEntryJSON(StringBuilder builder, String entryName) {
        builder.append("{\"name\":\"").append(entryName).append("\",");
    }

    public List<EObject> getUniqueChildren(List<EObject> prev, EObject artifact) {
        List conNow = this.traceAdapter.getConnectedElements(artifact, this.traceModel);
        ArrayList<EObject> allConnected = new ArrayList<EObject>(TraceHelper.getTracedElements((Collection)conNow));
        if (EMFHelper.isElementInList(allConnected, (EObject)artifact)) {
            allConnected.remove(artifact);
        }
        if (prev != null) {
            for (EObject x : prev) {
                if (!EMFHelper.isElementInList(allConnected, (EObject)x)) continue;
                allConnected.remove(x);
            }
        }
        return allConnected;
    }

    private class SelectDepthAction
    extends Action {
        private SelectDepthAction() {
        }

        public void run() {
            IInputValidator numberValidator = newText -> {
                boolean validationError = false;
                try {
                    int i = Integer.parseInt(newText);
                    if (i < 1) {
                        validationError = true;
                    }
                }
                catch (NumberFormatException ex) {
                    validationError = true;
                }
                if (validationError) {
                    return "Please enter a valid number larger than 0.";
                }
                return null;
            };
            InputDialog dialog = new InputDialog(SunburstView.this.getViewSite().getShell(), "Trace link depth", "Please select the maximum depth until which traceability links will be traversed for the Sunburst view.", String.valueOf(SunburstView.this.maxRecursionLevel), numberValidator);
            dialog.setBlockOnOpen(true);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                SunburstView.this.maxRecursionLevel = Integer.parseInt(dialog.getValue());
                SunburstView.this.preferences.putInt("MAX_RECURSION_LEVEL", SunburstView.this.maxRecursionLevel);
                try {
                    SunburstView.this.preferences.flush();
                }
                catch (BackingStoreException e) {
                    e.printStackTrace();
                }
                SunburstView.this.browser.setText(SunburstView.this.createHTML());
            }
        }
    }
}

