/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.core.handlers;

import java.lang.reflect.ParameterizedType;
import java.util.Optional;
import java.util.function.BiFunction;
import org.eclipse.capra.core.handlers.IArtifactHandler;
import org.eclipse.capra.core.handlers.IArtifactUnpacker;

public abstract class AbstractArtifactHandler<T>
implements IArtifactHandler<T> {
    private Object unpack(Object artifact) {
        Object result = artifact;
        if (IArtifactUnpacker.class.isAssignableFrom(this.getClass())) {
            try {
                result = ((IArtifactUnpacker)IArtifactUnpacker.class.cast(this)).unpack(artifact);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public <R> Optional<R> withCastedHandler(Object artifact, BiFunction<IArtifactHandler<T>, T, R> handleFunction) {
        Object unpackedArtifact = this.unpack(artifact);
        if (this.canHandleArtifact(unpackedArtifact)) {
            Object a = unpackedArtifact;
            return Optional.of(handleFunction.apply(this, (AbstractArtifactHandler)a));
        }
        return Optional.empty();
    }

    @Override
    public <R> R withCastedHandlerUnchecked(Object artifact, BiFunction<IArtifactHandler<T>, T, R> handleFunction) {
        return this.withCastedHandler(artifact, handleFunction).orElseThrow(() -> new IllegalArgumentException("withCastedHanderUnchecked called with unhandleble artifact. Artifact: " + artifact + ", handler: " + this));
    }

    @Override
    public boolean canHandleArtifact(Object artifact) {
        Object unpackedArtifact = this.unpack(artifact);
        try {
            Class genericType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            return genericType.isAssignableFrom(unpackedArtifact.getClass());
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    @Override
    public Class<T> getHandledClass() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }
}

