/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.plantuml;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ToggleDisplayGraphHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Command command = event.getCommand();
        boolean oldValue = HandlerUtil.toggleCommandState((Command)command);
        ToggleDisplayGraphHandler.setDisplayGraph(!oldValue);
        return null;
    }

    public static boolean isDisplayGraph() {
        Preferences graphDisplay = ToggleDisplayGraphHandler.getPreference();
        return graphDisplay.get("option", "matrix").equals("graph");
    }

    private static Preferences getPreference() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.capra.ui.plantuml.displayGraph");
        Preferences transitivity = preferences.node("displayGraph");
        return transitivity;
    }

    public static void setDisplayGraph(boolean value) {
        Preferences transitivity = ToggleDisplayGraphHandler.getPreference();
        transitivity.put("option", value ? "graph" : "matrix");
        try {
            transitivity.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }
}

