/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.generic.persistance;

import java.io.IOException;
import java.util.Optional;
import org.eclipse.capra.core.adapters.ArtifactMetaModelAdapter;
import org.eclipse.capra.core.adapters.TraceMetaModelAdapter;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class TracePersistenceAdapter
implements org.eclipse.capra.core.adapters.TracePersistenceAdapter {
    private static final String DEFAULT_PROJECT_NAME = "__WorkspaceTraceModels";
    private static final String DEFAULT_TRACE_MODEL_NAME = "traceModel.xmi";
    private static final String DEFAULT_ARTIFACT_WRAPPER_MODEL_NAME = "artifactWrappers.xmi";

    private Optional<EObject> loadModel(ResourceSet resourceSet, String modelName) {
        if (this.projectExist(DEFAULT_PROJECT_NAME) && this.fileExists("__WorkspaceTraceModels/" + modelName)) {
            try {
                URI uri = URI.createPlatformResourceURI((String)("__WorkspaceTraceModels/" + modelName), (boolean)true);
                Resource resource = resourceSet.getResource(uri, true);
                resource.load(null);
                return Optional.of((EObject)resource.getContents().get(0));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return Optional.empty();
    }

    public EObject getTraceModel(ResourceSet resourceSet) {
        TraceMetaModelAdapter adapter = (TraceMetaModelAdapter)ExtensionPointHelper.getTraceMetamodelAdapter().get();
        return this.loadModel(resourceSet, DEFAULT_TRACE_MODEL_NAME).orElse(adapter.createModel());
    }

    private boolean fileExists(String path) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path)).exists();
    }

    private boolean projectExist(String defaultProjectName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(defaultProjectName).exists();
    }

    private IProject ensureProjectExists(String defaultProjectName) throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(defaultProjectName);
        if (!project.exists()) {
            project.create((IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        return project;
    }

    public void saveTracesAndArtifacts(EObject traceModel, EObject artifactModel) {
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            URI uri = URI.createPlatformResourceURI((String)"__WorkspaceTraceModels/traceModel.xmi", (boolean)true);
            Resource resource = resourceSet.createResource(uri);
            resource.getContents().add((Object)traceModel);
            uri = URI.createPlatformResourceURI((String)"__WorkspaceTraceModels/artifactWrappers.xmi", (boolean)true);
            Resource resourceForArtifacts = resourceSet.createResource(uri);
            resourceForArtifacts.getContents().add((Object)artifactModel);
            this.ensureProjectExists(DEFAULT_PROJECT_NAME);
            resourceForArtifacts.save(null);
            resource.save(null);
        }
        catch (Exception e) {
            System.err.println("Unable to save trace model!");
            e.printStackTrace();
        }
    }

    public EObject getArtifactWrappers(ResourceSet resourceSet) {
        ArtifactMetaModelAdapter adapter = (ArtifactMetaModelAdapter)ExtensionPointHelper.getArtifactWrapperMetaModelAdapter().get();
        return this.loadModel(resourceSet, DEFAULT_ARTIFACT_WRAPPER_MODEL_NAME).orElse(adapter.createModel());
    }

    public EObject getTraceModel(EObject object) {
        return null;
    }

    public EObject getArtifactWrappers(EObject object) {
        return null;
    }
}

