/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.generic.tracemodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.capra.core.adapters.AbstractMetaModelAdapter;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.TraceMetaModelAdapter;
import org.eclipse.capra.core.adapters.TracePersistenceAdapter;
import org.eclipse.capra.core.handlers.IArtifactHandler;
import org.eclipse.capra.core.helpers.ArtifactHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.generic.tracemodel.GenericTraceModel;
import org.eclipse.capra.generic.tracemodel.RelatedTo;
import org.eclipse.capra.generic.tracemodel.TracemodelFactory;
import org.eclipse.capra.generic.tracemodel.TracemodelPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericMetaModelAdapter
extends AbstractMetaModelAdapter
implements TraceMetaModelAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(GenericMetaModelAdapter.class);
    private static final int DEFAULT_INITIAL_TRANSITIVITY_DEPTH = 1;

    public EObject createModel() {
        return TracemodelFactory.eINSTANCE.createGenericTraceModel();
    }

    public Collection<EClass> getAvailableTraceTypes(List<EObject> selection) {
        ArrayList<EClass> traceTypes = new ArrayList<EClass>();
        if (selection.size() > 1) {
            traceTypes.add(TracemodelPackage.eINSTANCE.getRelatedTo());
        }
        return traceTypes;
    }

    public EObject createTrace(EClass traceType, EObject traceModel, List<EObject> selection) {
        GenericTraceModel tm = (GenericTraceModel)traceModel;
        EObject trace = TracemodelFactory.eINSTANCE.create(traceType);
        RelatedTo relatedToTrace = (RelatedTo)trace;
        relatedToTrace.getItem().addAll(selection);
        TracePersistenceAdapter persistenceAdapter = (TracePersistenceAdapter)ExtensionPointHelper.getTracePersistenceAdapter().get();
        EObject artifactModel = persistenceAdapter.getArtifactWrappers((ResourceSet)new ResourceSetImpl());
        ArtifactHelper artifactHelper = new ArtifactHelper(artifactModel);
        StringBuilder name = new StringBuilder();
        for (EObject obj : selection) {
            name.append(" ").append(((IArtifactHandler)artifactHelper.getHandler(artifactHelper.unwrapWrapper((Object)obj)).get()).withCastedHandler(artifactHelper.unwrapWrapper((Object)obj), (h, e) -> h.getDisplayName(e)).orElseGet(obj::toString));
        }
        relatedToTrace.setName(name.toString());
        tm.getTraces().add((Object)relatedToTrace);
        return relatedToTrace;
    }

    public boolean isThereATraceBetween(EObject firstElement, EObject secondElement, EObject traceModel) {
        GenericTraceModel root = (GenericTraceModel)traceModel;
        ArrayList<RelatedTo> relevantLinks = new ArrayList<RelatedTo>();
        EList<RelatedTo> allTraces = root.getTraces();
        for (RelatedTo trace : allTraces) {
            if (firstElement.equals(secondElement) || !trace.getItem().contains((Object)firstElement) || !trace.getItem().contains((Object)secondElement)) continue;
            relevantLinks.add(trace);
        }
        return relevantLinks.size() > 0;
    }

    public List<Connection> getConnectedElements(EObject element, EObject tracemodel) {
        GenericTraceModel root = (GenericTraceModel)tracemodel;
        ArrayList<Connection> connections = new ArrayList<Connection>();
        EList<RelatedTo> traces = root.getTraces();
        if (element instanceof RelatedTo) {
            RelatedTo trace = (RelatedTo)element;
            connections.add(new Connection(element, trace.getItem(), (EObject)trace));
        } else {
            for (RelatedTo trace : traces) {
                for (EObject item : trace.getItem()) {
                    if (!EcoreUtil.equals((EObject)item, (EObject)element)) continue;
                    connections.add(new Connection(element, trace.getItem(), (EObject)trace));
                }
            }
        }
        return connections;
    }

    public List<Connection> getConnectedElements(EObject element, EObject tracemodel, List<String> selectedRelationshipTypes) {
        GenericTraceModel root = (GenericTraceModel)tracemodel;
        ArrayList<Connection> connections = new ArrayList<Connection>();
        EList<RelatedTo> traces = root.getTraces();
        if (selectedRelationshipTypes.size() == 0 || selectedRelationshipTypes.contains(TracemodelPackage.eINSTANCE.getRelatedTo().getName())) {
            if (element instanceof RelatedTo) {
                RelatedTo trace = (RelatedTo)element;
                connections.add(new Connection(element, trace.getItem(), (EObject)trace));
            } else {
                for (RelatedTo trace : traces) {
                    for (EObject item : trace.getItem()) {
                        if (!EcoreUtil.equals((EObject)item, (EObject)element)) continue;
                        connections.add(new Connection(element, trace.getItem(), (EObject)trace));
                    }
                }
            }
        }
        return connections;
    }

    private List<Connection> getTransitivelyConnectedElements(EObject element, EObject traceModel, List<Object> accumulator, int currentDepth, int maximumDepth) {
        List<Connection> directElements = this.getConnectedElements(element, traceModel);
        ArrayList<Connection> allElements = new ArrayList<Connection>();
        int currDepth = currentDepth + 1;
        for (Connection connection : directElements) {
            if (accumulator.contains(connection.getTlink())) continue;
            allElements.add(connection);
            accumulator.add(connection.getTlink());
            for (EObject e : connection.getTargets()) {
                if (maximumDepth != 0 && currDepth > maximumDepth) continue;
                allElements.addAll(this.getTransitivelyConnectedElements(e, traceModel, accumulator, currDepth, maximumDepth));
            }
        }
        return allElements;
    }

    public List<Connection> getTransitivelyConnectedElements(EObject element, EObject traceModel, int maximumDepth) {
        ArrayList<Object> accumulator = new ArrayList<Object>();
        return this.getTransitivelyConnectedElements(element, traceModel, accumulator, 1, maximumDepth);
    }

    public List<Connection> getAllTraceLinks(EObject traceModel) {
        GenericTraceModel model = (GenericTraceModel)traceModel;
        ArrayList<Connection> allLinks = new ArrayList<Connection>();
        for (RelatedTo trace : model.getTraces()) {
            ArrayList<EObject> allItems = new ArrayList<EObject>();
            allItems.addAll((Collection<EObject>)trace.getItem());
            EObject origin = (EObject)allItems.get(0);
            allItems.remove(0);
            allLinks.add(new Connection(origin, allItems, (EObject)trace));
        }
        return allLinks;
    }

    public void deleteTrace(List<Connection> toDelete, EObject traceModel) {
        ArrayList<RelatedTo> toRemove = new ArrayList<RelatedTo>();
        if (traceModel instanceof GenericTraceModel) {
            GenericTraceModel tModel = (GenericTraceModel)traceModel;
            for (Connection c : toDelete) {
                for (RelatedTo trace : tModel.getTraces()) {
                    if (!EcoreUtil.equals((EObject)trace, (EObject)c.getTlink())) continue;
                    toRemove.add(trace);
                }
            }
            for (Object trace : toRemove) {
                tModel.getTraces().remove(trace);
            }
            TracePersistenceAdapter persistenceAdapter = (TracePersistenceAdapter)ExtensionPointHelper.getTracePersistenceAdapter().get();
            persistenceAdapter.saveTracesAndArtifacts((EObject)tModel, persistenceAdapter.getArtifactWrappers((ResourceSet)new ResourceSetImpl()));
        }
    }

    public List<Connection> getTransitivelyConnectedElements(EObject element, EObject traceModel, List<String> selectedRelationshipTypes, int maximumDepth) {
        ArrayList<Object> accumulator = new ArrayList<Object>();
        return this.getTransitivelyConnectedElements(element, traceModel, accumulator, selectedRelationshipTypes, 1, maximumDepth);
    }

    private List<Connection> getTransitivelyConnectedElements(EObject element, EObject traceModel, List<Object> accumulator, List<String> selectedRelationshipTypes, int currentDepth, int maximumDepth) {
        List<Connection> directElements = this.getConnectedElements(element, traceModel, selectedRelationshipTypes);
        ArrayList<Connection> allElements = new ArrayList<Connection>();
        int currDepth = currentDepth + 1;
        for (Connection connection : directElements) {
            if (accumulator.contains(connection.getTlink())) continue;
            allElements.add(connection);
            accumulator.add(connection.getTlink());
            for (EObject e : connection.getTargets()) {
                if (maximumDepth != 0 && currDepth > maximumDepth) continue;
                allElements.addAll(this.getTransitivelyConnectedElements(e, traceModel, accumulator, selectedRelationshipTypes, currDepth, maximumDepth));
            }
        }
        return allElements;
    }
}

