/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.plantuml;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.TracePersistenceAdapter;
import org.eclipse.capra.core.handlers.IArtifactHandler;
import org.eclipse.capra.core.helpers.ArtifactHelper;
import org.eclipse.capra.core.helpers.EMFHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.generic.artifactmodel.ArtifactWrapper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class Connections {
    private static final String CHARACTERS_TO_BE_REMOVED = "[\", ']";
    private List<Connection> connections;
    private EObject origin;
    private Set<EObject> allObjects;
    private Map<EObject, String> object2Id;
    private Map<String, String> id2Label;
    private Map<String, String> id2Location;

    Connections(List<Connection> connections, List<EObject> selectedObjects) {
        this.connections = connections;
        this.origin = selectedObjects.get(0);
        this.allObjects = new LinkedHashSet<EObject>();
        this.allObjects.addAll(selectedObjects);
        connections.forEach(c -> {
            boolean bl = this.allObjects.addAll(c.getTargets());
        });
        this.object2Id = new LinkedHashMap<EObject, String>();
        int i = 0;
        for (EObject o2 : this.allObjects) {
            this.object2Id.put(o2, "o" + i++);
        }
        this.id2Label = new LinkedHashMap<String, String>();
        this.allObjects.forEach(o -> {
            String id = this.object2Id.get(o);
            this.id2Label.put(id, Connections.getArtifactLabel(o));
        });
        this.id2Location = new LinkedHashMap<String, String>();
        this.allObjects.forEach(o -> {
            String id = this.object2Id.get(o);
            this.id2Location.put(id, Connections.getArtifactLocation(o));
        });
    }

    public String originLabel() {
        return this.id2Label.get(this.object2Id.get(this.origin));
    }

    public String originLocation() {
        return this.id2Location.get(this.object2Id.get(this.origin));
    }

    public boolean originHasLocation() {
        return !Strings.isNullOrEmpty((String)this.id2Location.get(this.object2Id.get(this.origin)));
    }

    public String originId() {
        return this.object2Id.get(this.origin);
    }

    public Collection<String> objectIdsWithoutOrigin() {
        ArrayList<String> all = new ArrayList<String>();
        all.addAll(this.object2Id.values());
        all.remove(this.originId());
        return all;
    }

    public String label(String id) {
        return this.id2Label.get(id);
    }

    public String location(String id) {
        return this.id2Location.get(id);
    }

    public boolean hasLocation(String id) {
        return !Strings.isNullOrEmpty((String)this.id2Location.get(id));
    }

    public List<String> arrows() {
        HashSet arrows = new HashSet();
        this.connections.forEach(c -> c.getTargets().forEach(trg -> {
            if (!trg.equals(c.getOrigin())) {
                arrows.add(String.valueOf(this.object2Id.get(c.getOrigin())) + "--" + this.object2Id.get(trg) + ":" + EMFHelper.getIdentifier((EObject)c.getTlink()));
            }
        }));
        return arrows.stream().collect(Collectors.toList());
    }

    public static String getArtifactLabel(EObject object) {
        String artifactLabel = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        TracePersistenceAdapter persistenceAdapter = (TracePersistenceAdapter)ExtensionPointHelper.getTracePersistenceAdapter().get();
        EObject artifactModel = persistenceAdapter.getArtifactWrappers((ResourceSet)resourceSet);
        ArtifactHelper artifactHelper = new ArtifactHelper(artifactModel);
        Object originalObject = artifactHelper.unwrapWrapper((Object)object);
        if (originalObject != null) {
            IArtifactHandler handler = (IArtifactHandler)artifactHelper.getHandler(originalObject).get();
            artifactLabel = (String)handler.withCastedHandler(originalObject, (h, o) -> h.getDisplayName(o)).orElseThrow(IllegalArgumentException::new);
        } else {
            String label = EMFHelper.getIdentifier((EObject)object);
            artifactLabel = label.substring(0, label.indexOf(58));
        }
        if (artifactLabel != null) {
            return artifactLabel.replaceAll(CHARACTERS_TO_BE_REMOVED, " ");
        }
        return "Unknown (no fitting artifact handler found)";
    }

    public static String getArtifactLocation(EObject object) {
        String artifactLink = null;
        if (object instanceof ArtifactWrapper) {
            ArtifactWrapper wrapper = (ArtifactWrapper)object;
            artifactLink = wrapper.getUri();
        } else {
            try {
                artifactLink = EcoreUtil.getURI((EObject)object).toPlatformString(false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (!Strings.isNullOrEmpty(artifactLink) && artifactLink.startsWith("/")) {
            artifactLink = "platform:/resource" + artifactLink;
        }
        return artifactLink;
    }
}

