/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.generic.persistence;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.capra.core.adapters.IArtifactMetaModelAdapter;
import org.eclipse.capra.core.adapters.IMetadataAdapter;
import org.eclipse.capra.core.adapters.IPersistenceAdapter;
import org.eclipse.capra.core.adapters.ITraceabilityInformationModelAdapter;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.core.preferences.CapraPreferences;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericPersistenceAdapter
implements IPersistenceAdapter {
    private static final String NAMESPACE_VERSION_REGEX = "http://www.eclipse.org/.*(\\d.\\d.\\d)";
    private static final String NEW_NAMESPACE_IN_TRACES_XCORE = "http://www.eclipse.org/capra/traces/0.7.0";
    private static final String NEW_NAMESPACE_IN_ARTIFACTS_XCORE = "http://www.eclipse.org/capra/artifacts/0.7.0";
    private static final String OLD_NAMESPACE_IN_TRACES_XCORE = "org.eclipse.capra.generic.tracemodel";
    private static final String OLD_NAMESPACE_IN_ARTIFACTS_XCORE = "org.eclipse.capra.generic.artifactmodel";
    private static final Logger LOG = LoggerFactory.getLogger(GenericPersistenceAdapter.class);
    private static String DEFAULT_PROJECT_NAME = "__WorkspaceTraceModels";
    private static final String DEFAULT_TRACE_MODEL_NAME = "traceModel.capra";
    private static final String DEFAULT_ARTIFACT_WRAPPER_MODEL_NAME = "artifactWrappers.capra";
    private static final String DEFAULT_METADATA_MODEL_NAME = "metadata.capra";

    private String getTargetString(String strOrigin, Pattern pattern) {
        if (strOrigin == null || pattern == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(strOrigin);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private Optional<EObject> loadModel(ResourceSet resourceSet, String modelName) {
        return this.loadModel(this.getProjectNamePreference(), resourceSet, modelName);
    }

    private void setDefaultVersion(IFile file, String modelName) throws IOException {
        if (!file.exists()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(file.getContents(), file.getCharset()));){
                Object matcher;
                StringBuffer inputBuffer = new StringBuffer();
                String line = null;
                String strRegex = null;
                String strReplace = null;
                switch (modelName) {
                    case "traceModel.capra": {
                        strRegex = OLD_NAMESPACE_IN_TRACES_XCORE;
                        strReplace = NEW_NAMESPACE_IN_TRACES_XCORE;
                        break;
                    }
                    case "artifactWrappers.capra": {
                        strRegex = OLD_NAMESPACE_IN_ARTIFACTS_XCORE;
                        strReplace = NEW_NAMESPACE_IN_ARTIFACTS_XCORE;
                    }
                }
                Pattern pattern = Pattern.compile(strRegex);
                boolean bStopSearching = false;
                while ((line = bufferedReader.readLine()) != null) {
                    if (!bStopSearching && ((Matcher)(matcher = pattern.matcher(line))).find()) {
                        line = ((Matcher)matcher).replaceAll(strReplace);
                        bStopSearching = true;
                    }
                    inputBuffer.append(line);
                    inputBuffer.append(System.lineSeparator());
                }
                try {
                    matcher = null;
                    Object var14_19 = null;
                    try (ByteArrayInputStream newContent = new ByteArrayInputStream(inputBuffer.toString().getBytes());){
                        file.setContents((InputStream)newContent, true, true, null);
                        LOG.debug("Updated namespace of file {}", (Object)modelName);
                    }
                    catch (Throwable throwable2) {
                        if (matcher == null) {
                            matcher = throwable2;
                        } else if (matcher != throwable2) {
                            ((Throwable)matcher).addSuppressed(throwable2);
                        }
                        throw matcher;
                    }
                }
                catch (CoreException e) {
                    LOG.error("Failed to set contents for file {}", (Object)modelName, (Object)e);
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (CoreException e) {
            LOG.error("Failed to get contents from file {}", (Object)modelName, (Object)e);
        }
    }

    private String getModelVersion(String projectName, String modelName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IFile file = project.getFile(modelName);
        String strVersion = null;
        if (file.exists()) {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(file.getContents(), file.getCharset()));){
                    String line = null;
                    String namespaceRegexString = NAMESPACE_VERSION_REGEX;
                    Pattern pattern = Pattern.compile(namespaceRegexString);
                    while ((line = bufferedReader.readLine()) != null) {
                        strVersion = this.getTargetString(line, pattern);
                        if (strVersion == null || strVersion.isEmpty()) continue;
                        LOG.debug("Got version {} in {}.", (Object)strVersion, (Object)modelName);
                        break;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException e) {
                LOG.warn("Failed to get contents from file {}", (Object)modelName, (Object)e);
            }
        }
        return strVersion;
    }

    private void transformModel(String strVersion, String projectName, String modelName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IFile file = project.getFile(modelName);
        if (file != null && file.exists() && (strVersion == null || strVersion.isEmpty())) {
            LOG.debug("Could not find version string in {}, thus assuming version 0.7.0.", (Object)modelName);
            try {
                this.setDefaultVersion(file, modelName);
            }
            catch (IOException e) {
                LOG.warn("Failed to set default version in XMI file.", (Throwable)e);
            }
        }
    }

    private synchronized Optional<EObject> loadModel(String projectName, ResourceSet resourceSet, String modelName) {
        Resource resource;
        URI uri = URI.createPlatformResourceURI((String)(String.valueOf(projectName) + "/" + modelName), (boolean)true);
        Resource resource2 = resource = resourceSet.getResource(uri, false) != null ? resourceSet.getResource(uri, false) : resourceSet.createResource(uri);
        if (!resource.isLoaded()) {
            String strVersion = this.getModelVersion(projectName, modelName);
            this.transformModel(strVersion, projectName, modelName);
            try {
                resource.load(null);
            }
            catch (IOException e) {
                LOG.warn("Could not load {}: {}", (Object)modelName, (Object)e.getMessage());
                return Optional.empty();
            }
        }
        try {
            EList contents = (EList)TransactionUtil.runExclusive((TransactionalEditingDomain)EditingDomainHelper.getEditingDomain(), (RunnableWithResult)new RunnableWithResult.Impl<EList<EObject>>(){

                public void run() {
                    this.setResult(resource.getContents());
                }
            });
            return contents.isEmpty() ? Optional.empty() : Optional.of((EObject)contents.get(0));
        }
        catch (InterruptedException e) {
            LOG.error("Got interrupted when reading the model {}", (Object)modelName, (Object)e);
            return Optional.empty();
        }
    }

    private String getProjectNamePreference() {
        IEclipsePreferences pref = CapraPreferences.getPreferences();
        String projectName = pref.get("org.eclipse.capra.persistence.projectName", DEFAULT_PROJECT_NAME);
        if (projectName.isBlank() || projectName.isEmpty()) {
            projectName = DEFAULT_PROJECT_NAME;
        }
        return projectName;
    }

    private IProject ensureProjectExists(String defaultProjectName) throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(defaultProjectName);
        if (!project.exists()) {
            project.create((IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        return project;
    }

    public void saveModels(final EObject traceModel, final EObject artifactModel, final EObject metadataModel) {
        try {
            Resource resourceForMetadata;
            this.ensureProjectExists(this.getProjectNamePreference());
            ResourceSet resourceSet = EditingDomainHelper.getResourceSet();
            URI traceURI = URI.createPlatformResourceURI((String)(String.valueOf(this.getProjectNamePreference()) + "/" + DEFAULT_TRACE_MODEL_NAME), (boolean)true);
            URI artifactURI = URI.createPlatformResourceURI((String)(String.valueOf(this.getProjectNamePreference()) + "/" + DEFAULT_ARTIFACT_WRAPPER_MODEL_NAME), (boolean)true);
            URI metadataURI = URI.createPlatformResourceURI((String)(String.valueOf(this.getProjectNamePreference()) + "/" + DEFAULT_METADATA_MODEL_NAME), (boolean)true);
            final Resource resourceForTraces = resourceSet.getResource(traceURI, false) != null ? resourceSet.getResource(traceURI, false) : resourceSet.createResource(traceURI);
            final Resource resourceForArtifacts = resourceSet.getResource(artifactURI, false) != null ? resourceSet.getResource(artifactURI, false) : resourceSet.createResource(artifactURI);
            Resource resource = resourceForMetadata = resourceSet.getResource(metadataURI, false) != null ? resourceSet.getResource(metadataURI, false) : resourceSet.createResource(metadataURI);
            if (resourceForTraces.getContents().isEmpty() || resourceForTraces.getContents().isEmpty() || resourceForMetadata.getContents().isEmpty()) {
                TransactionalEditingDomain editingDomain = EditingDomainHelper.getEditingDomain();
                RecordingCommand cmd = new RecordingCommand(editingDomain, "Save Trace Model"){

                    protected void doExecute() {
                        if (resourceForTraces.getContents().isEmpty()) {
                            resourceForTraces.getContents().add((Object)traceModel);
                        }
                        if (resourceForArtifacts.getContents().isEmpty()) {
                            resourceForArtifacts.getContents().add((Object)artifactModel);
                        }
                        if (resourceForMetadata.getContents().isEmpty()) {
                            resourceForMetadata.getContents().add((Object)metadataModel);
                        }
                    }
                };
                try {
                    ((TransactionalCommandStack)editingDomain.getCommandStack()).execute((Command)cmd, null);
                }
                catch (RollbackException rbe) {
                    LOG.warn("Saving trace model has been rolled back.", (Throwable)rbe);
                }
            }
            resourceForArtifacts.save(null);
            resourceForTraces.save(null);
            resourceForMetadata.save(null);
        }
        catch (Exception e) {
            LOG.error("Unable to save trace model!", (Throwable)e);
        }
    }

    public void saveModels(ResourceSet resourceSet) {
        EObject traceModel = this.getTraceModel(resourceSet);
        EObject artifactModel = this.getArtifactWrappers(resourceSet);
        EObject metadataModel = this.getMetadataContainer(resourceSet);
        this.saveModels(traceModel, artifactModel, metadataModel);
    }

    public EObject getArtifactWrappers(ResourceSet resourceSet) {
        IArtifactMetaModelAdapter adapter = (IArtifactMetaModelAdapter)ExtensionPointHelper.getArtifactMetaModelAdapter().orElseThrow();
        return this.loadModel(resourceSet, DEFAULT_ARTIFACT_WRAPPER_MODEL_NAME).orElse(adapter.createModel());
    }

    public EObject getMetadataContainer(ResourceSet resourceSet) {
        IMetadataAdapter adapter = (IMetadataAdapter)ExtensionPointHelper.getTraceMetadataAdapter().orElseThrow();
        return this.loadModel(resourceSet, DEFAULT_METADATA_MODEL_NAME).orElse(adapter.createModel());
    }

    public EObject getTraceModel(ResourceSet resourceSet) {
        ITraceabilityInformationModelAdapter adapter = (ITraceabilityInformationModelAdapter)ExtensionPointHelper.getTraceabilityInformationModelAdapter().orElseThrow();
        return this.loadModel(resourceSet, DEFAULT_TRACE_MODEL_NAME).orElse(adapter.createModel());
    }
}

