/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.importer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.xmlpivot.XMLPivotActivator;
import org.polarsys.capella.xmlpivot.extraction.BasicConceptualMapping;
import org.polarsys.capella.xmlpivot.extraction.ConceptualMapping;
import org.polarsys.capella.xmlpivot.extraction.MemoizingConceptualMapping;
import org.polarsys.capella.xmlpivot.importer.ImportEngine;

public class ImportRunner {
    public Collection<EObject> run(Collection<? extends EObject> xmlPivotObjects, boolean dynamic_p, IProgressMonitor monitor_p) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor_p, (String)"XML Pivot Import", (int)100);
        Object mapping = null;
        mapping = dynamic_p ? XMLPivotActivator.getDefault().getDynamicConceptualMapping() : new MemoizingConceptualMapping((ConceptualMapping)new BasicConceptualMapping(EPackage.Registry.INSTANCE));
        ImportEngine engine = new ImportEngine((ConceptualMapping)mapping);
        engine.copyAll(xmlPivotObjects);
        progress.worked(25);
        engine.copyReferences();
        progress.worked(25);
        engine.repair();
        progress.worked(25);
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject e : engine.values()) {
            if (e.eContainer() != null) continue;
            result.add(e);
        }
        for (EObject e : engine.getOrphanedRecreatedAssociationLinks()) {
            if (e.eContainer() != null) continue;
            result.add(e);
        }
        this.cleanScenarios(result);
        monitor_p.worked(25);
        return result;
    }

    private void cleanScenarios(Collection<EObject> result) {
        ECrossReferenceAdapter adapter = new ECrossReferenceAdapter();
        for (EObject e : result) {
            e.eAdapters().add((Object)adapter);
        }
        TreeIterator it = EcoreUtil.getAllContents(result);
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (!(next instanceof Scenario)) continue;
            it.prune();
            for (SequenceMessage child : ((Scenario)next).getOwnedMessages()) {
                TreeIterator smIt = EcoreUtil.getAllContents(Collections.singleton(child));
                while (smIt.hasNext()) {
                    EObject smContent = (EObject)smIt.next();
                    for (EStructuralFeature.Setting setting : new ArrayList(adapter.getInverseReferences(smContent))) {
                        EObject holder = setting.getEObject();
                        EReference feature = (EReference)setting.getEStructuralFeature();
                        if (feature.isContainer() || feature.isContainment()) continue;
                        if (feature.isMany()) {
                            ((List)holder.eGet((EStructuralFeature)feature)).remove(smContent);
                            continue;
                        }
                        holder.eUnset((EStructuralFeature)feature);
                    }
                }
            }
            ((Scenario)next).getOwnedMessages().clear();
        }
        for (EObject e : result) {
            e.eAdapters().remove((Object)adapter);
        }
    }
}

