/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.semantic.data.modellingcore;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RateKind implements Enumerator
{
    UNSPECIFIED(0, "Unspecified", "Unspecified"),
    CONTINUOUS(1, "Continuous", "Continuous"),
    DISCRETE(2, "Discrete", "Discrete");

    public static final int UNSPECIFIED_VALUE = 0;
    public static final int CONTINUOUS_VALUE = 1;
    public static final int DISCRETE_VALUE = 2;
    private static final RateKind[] VALUES_ARRAY;
    public static final List<RateKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RateKind[]{UNSPECIFIED, CONTINUOUS, DISCRETE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RateKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RateKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RateKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RateKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RateKind get(int value) {
        switch (value) {
            case 0: {
                return UNSPECIFIED;
            }
            case 1: {
                return CONTINUOUS;
            }
            case 2: {
                return DISCRETE;
            }
        }
        return null;
    }

    private RateKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

