/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.ui;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.polarsys.capella.core.platform.sirius.ui.project.NewProjectWizard;
import org.polarsys.capella.core.platform.sirius.ui.project.operations.SessionCreationHelper;
import org.polarsys.capella.xmlpivot.ui.PivotSessionCreationHelper;

public class NewCapellaProjectWizard
extends NewProjectWizard {
    private ImportSpecPage page;
    protected IStructuredSelection selection;

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() != this.page && super.canFinish();
    }

    public void addPages() {
        this.page = new ImportSpecPage();
        this.addPage((IWizardPage)this.page);
        super.addPages();
    }

    public void init(IWorkbench workbench_p, IStructuredSelection currentSelection_p) {
        this.selection = currentSelection_p;
        super.init(workbench_p, currentSelection_p);
    }

    protected SessionCreationHelper createSessionCreationHelper() {
        return new PivotSessionCreationHelper(this.getShell(), this._modelPage.isEpbsSelected(), this._modelPage.isOpaSelected(), this.getProjectApproach(), this.page.getURI());
    }

    private class ImportSpecPage
    extends WizardPage {
        private URI uri;

        protected ImportSpecPage() {
            super("Select XML Pivot Import Source");
            this.setTitle("Capella Project");
            this.setMessage("Select an existing XML Pivot file");
            this.setPageComplete(false);
        }

        public URI getURI() {
            return this.uri;
        }

        public void createControl(Composite parent_p) {
            IFile file;
            Composite composite = new Composite(parent_p, 0);
            this.setControl((Control)composite);
            composite.setLayout((Layout)new GridLayout(3, false));
            Label label = new Label(composite, 0);
            label.setText("Location:");
            final Text text = new Text(composite, 2052);
            text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Button button = new Button(composite, 8);
            button.setText("B&rowse...");
            button.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e_p) {
                    FileDialog dialog = new FileDialog(ImportSpecPage.this.getShell(), 4096);
                    String[] filterNames = new String[]{"XML Files", "All Files (*)"};
                    String[] filterExtensions = new String[]{"*.xml", "*"};
                    String filterPath = "/";
                    String platform = SWT.getPlatform();
                    if (platform.equals("win32") || platform.equals("wpf")) {
                        filterNames = new String[]{"XML Pivot Files", "All Files (*)"};
                        filterExtensions = new String[]{"*.xml", "*.*"};
                        filterPath = "c:\\";
                    }
                    dialog.setFilterNames(filterNames);
                    dialog.setFilterExtensions(filterExtensions);
                    dialog.setFilterPath(filterPath);
                    String file = dialog.open();
                    if (file != null) {
                        text.setText(file);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e_p) {
                }
            });
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent arg0_p) {
                    block7: {
                        ImportSpecPage.this.setPageComplete(false);
                        if (!((Text)arg0_p.widget).getText().matches("\\s*")) {
                            try {
                                URI fileURI = URI.createFileURI((String)((Text)arg0_p.widget).getText());
                                if (new File(fileURI.toFileString()).exists()) {
                                    try {
                                        new ResourceSetImpl().getURIConverter().createInputStream(fileURI);
                                        ImportSpecPage.this.uri = fileURI;
                                        ImportSpecPage.this.setErrorMessage(null);
                                        ImportSpecPage.this.setPageComplete(true);
                                    }
                                    catch (IOException e) {
                                        ImportSpecPage.this.setErrorMessage(e.getMessage());
                                    }
                                    break block7;
                                }
                                ImportSpecPage.this.setErrorMessage("File does not exist");
                            }
                            catch (IllegalArgumentException e) {
                                ImportSpecPage.this.setErrorMessage("Please enter a valid file path");
                            }
                        } else {
                            ImportSpecPage.this.setErrorMessage(null);
                        }
                    }
                }
            });
            if (NewCapellaProjectWizard.this.selection != null && NewCapellaProjectWizard.this.selection.getFirstElement() instanceof IFile && "xml".equals((file = (IFile)NewCapellaProjectWizard.this.selection.getFirstElement()).getFileExtension())) {
                text.setText(file.getLocation().toString());
            }
        }
    }
}

