/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.domain.file;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.eclipse.egf.domain.DomainException;
import org.eclipse.egf.domain.LoadableDomainHelper;
import org.eclipse.egf.domain.Messages;
import org.eclipse.egf.model.domain.FilesystemDomain;
import org.eclipse.egf.model.domain.LoadableDomain;

public class FilesystemDomainHelper
extends LoadableDomainHelper {
    @Override
    protected boolean doLoadDomain(LoadableDomain domain) throws DomainException {
        if (domain instanceof FilesystemDomain) {
            FilesystemDomain myDomain = (FilesystemDomain)domain;
            myDomain.setLoaded(true);
            File file = new File(myDomain.getPath());
            if (!file.exists()) {
                throw new DomainException(Messages.bind((String)Messages.Load_FilesystemDomain_error1, (Object)myDomain.getPath()));
            }
            if (!myDomain.getContent().isEmpty()) {
                throw new DomainException(Messages.bind((String)Messages.Load_Domain_error1, (Object)domain.eClass().getName(), (Object)domain.getName()));
            }
            List<File> children = Arrays.asList(file.listFiles());
            myDomain.getContent().addAll(children);
            return true;
        }
        return false;
    }

    @Override
    protected boolean doUnLoadDomain(LoadableDomain domain) throws DomainException {
        if (domain instanceof FilesystemDomain) {
            FilesystemDomain myDomain = (FilesystemDomain)domain;
            myDomain.getContent().clear();
            myDomain.setLoaded(false);
            return true;
        }
        return false;
    }
}

