/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.fcore.helper;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.egf.model.fcore.Contract;
import org.eclipse.egf.model.fcore.ContractMode;
import org.eclipse.egf.model.fcore.FactoryComponent;
import org.eclipse.egf.model.fcore.FactoryComponentContract;
import org.eclipse.egf.model.fcore.InvocationContract;
import org.eclipse.emf.common.util.UniqueEList;

public class FactoryComponentContractHelper {
    private FactoryComponentContractHelper() {
    }

    public static Collection<InvocationContract> getAvailableInvocationContracts(FactoryComponentContract factoryComponentContract) {
        UniqueEList result = new UniqueEList();
        if (factoryComponentContract.getType() == null || factoryComponentContract.getActivity() == null) {
            return result;
        }
        FactoryComponent factoryComponent = (FactoryComponent)factoryComponentContract.getActivity();
        if (factoryComponentContract.getMode() != ContractMode.IN && factoryComponentContract.getInvocationContracts().size() != 0) {
            return result;
        }
        result.addAll(factoryComponent.getInvocationContracts(factoryComponentContract.getType(), factoryComponentContract.getMode()));
        if (result.size() > 0) {
            Iterator it = result.iterator();
            while (it.hasNext()) {
                InvocationContract invocationContract = (InvocationContract)it.next();
                if (invocationContract.getOrchestrationParameter() != null && factoryComponentContract.getMode() != ContractMode.OUT) {
                    it.remove();
                }
                if (invocationContract.getSourceInvocationContract() == null || factoryComponentContract.getMode() == ContractMode.OUT) continue;
                it.remove();
            }
            for (Contract innerContract : factoryComponent.getContracts(factoryComponentContract.getType(), factoryComponentContract.getMode())) {
                if (factoryComponentContract == innerContract) continue;
                for (InvocationContract invocationContract : ((FactoryComponentContract)innerContract).getInvocationContracts()) {
                    result.remove(invocationContract);
                }
            }
        }
        return result;
    }
}

