/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.sirius.util.session;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DRepresentation;

public class DiagramSessionHelper {
    private static URI airdUri;
    private static Session session;

    public static Session initSession() {
        if (!(session != null && session.isOpen() || airdUri == null)) {
            session = DiagramSessionHelper.findCorrespondingActiveSession(airdUri);
        }
        return session;
    }

    public static Session initSessionFromAirdURI(URI airdURI) {
        if (session == null) {
            session = DiagramSessionHelper.findCorrespondingActiveSession(airdURI);
        }
        return session;
    }

    public static Session findCorrespondingActiveSession(URI uri) {
        return SessionManager.INSTANCE.getSession(uri, (IProgressMonitor)new NullProgressMonitor());
    }

    public static Session getCurrentSession() {
        return session;
    }

    public static void setAirdUri(URI airdUri) {
        DiagramSessionHelper.airdUri = airdUri;
    }

    public static URI getAirdUri() {
        return airdUri;
    }

    public static Collection<DRepresentation> getSessionDRepresentation() {
        if (session != null) {
            return DialectManager.INSTANCE.getAllRepresentations(session);
        }
        return Collections.emptyList();
    }

    public static void cleanSession() {
        session = null;
    }
}

