/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.extension.point.manager;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.model.fcore.FactoryComponent;
import org.eclipse.egf.model.fcore.Viewpoint;
import org.eclipse.egf.model.fcore.ViewpointContainer;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternLibrary;
import org.eclipse.egf.model.pattern.PatternViewpoint;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.polarsys.kitalpha.doc.gen.business.core.Activator;
import org.polarsys.kitalpha.doc.gen.business.core.extension.point.manager.DocGenExtensionElement;
import org.polarsys.kitalpha.doc.gen.business.core.extension.point.manager.IDocGenExtensionElement;

public class DocGenContentExtensionManager {
    private static final String DOCGEN_CONTENT_EXTENSION = "org.polarsys.kitalpha.doc.gen.business.core.contentExtension";
    private static final String DOCGEN_CONTENT_EXTENSION_ELEMENT = "contentExtension";
    private static final String DOCGEN_CONTENT_EXTENSION_PATTERN_URI = "patternURI";
    private static final String DOCGEN_CONTENT_EXTENSION_FCORES = "fcores";
    private static final String DOCGEN_PRIORITY = "priority";
    private static final String DOCGEN_TOPIC = "topic";
    private ResourceSet egfResourceSet = new ResourceSetImpl();

    public Collection<IDocGenExtensionElement> getDocGenExtensions() {
        LinkedHashSet<IDocGenExtensionElement> result = new LinkedHashSet<IDocGenExtensionElement>();
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(DOCGEN_CONTENT_EXTENSION);
        if (config.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement elt = iConfigurationElementArray[n2];
                if (elt.getName().equalsIgnoreCase(DOCGEN_CONTENT_EXTENSION_ELEMENT)) {
                    LinkedHashSet<Pattern> patterns = new LinkedHashSet<Pattern>();
                    String topics = elt.getAttribute(DOCGEN_TOPIC);
                    String[] topicTokens = this.getTopicTokens(topics);
                    IConfigurationElement[] children = elt.getChildren(DOCGEN_CONTENT_EXTENSION_FCORES);
                    String _priority = elt.getAttribute(DOCGEN_PRIORITY);
                    Integer priority = -1;
                    try {
                        priority = Integer.valueOf(_priority);
                    }
                    catch (NumberFormatException e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(2, "org.polarsys.kitalpha.doc.gen.business.core", "Priority must be an Integer for " + topics.replace("|", ",") + ". The default (-1) priority is set to this contribution"));
                    }
                    Object[] objectArray = children;
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement _elt = objectArray[n4];
                        String fcorePath = _elt.getAttribute(DOCGEN_CONTENT_EXTENSION_PATTERN_URI);
                        URI uri = URI.createURI((String)fcorePath);
                        EObject eObject = this.egfResourceSet.getEObject(uri, true);
                        if (eObject instanceof Pattern) {
                            this.getPattern((Pattern)eObject, patterns);
                        }
                        if (eObject instanceof PatternLibrary) {
                            this.getPattern((PatternLibrary)eObject, patterns);
                        }
                        if (eObject instanceof FactoryComponent) {
                            this.getPattern((FactoryComponent)eObject, patterns);
                        }
                        ++n4;
                    }
                    if (topicTokens == null || topicTokens.length == 0) {
                        IllegalArgumentException e = new IllegalArgumentException("Topic must be not null or empty. See the documentation for more details");
                        Activator.getDefault().getLog().log((IStatus)new Status(2, "org.polarsys.kitalpha.doc.gen.business.core", "Topic must be not null or empty. See the documentation for more details", (Throwable)e));
                        throw e;
                    }
                    objectArray = topicTokens;
                    n3 = topicTokens.length;
                    n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement topic = objectArray[n4];
                        result.add(this.createDocGenExtensionElement((String)topic, priority, patterns));
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    private String[] getTopicTokens(String topic) {
        String idPattern = "[a-zA-Z][a-zA-Z0-9\\.]*";
        java.util.regex.Pattern pattern = java.util.regex.Pattern.compile("[a-zA-Z][a-zA-Z0-9\\.]*");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        StringTokenizer s = new StringTokenizer(topic, ",");
        while (s.hasMoreTokens()) {
            String nextToken = s.nextToken();
            if (pattern.matcher(nextToken).find()) {
                if (nextToken.equalsIgnoreCase(",")) continue;
                result.add(nextToken.trim());
                continue;
            }
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.kitalpha.doc.gen.business.core", "The identifier" + nextToken + " is not valid. It must have only alphanumerics or with dot characters"));
        }
        return result.toArray(new String[0]);
    }

    public void dispose() {
        if (this.egfResourceSet != null) {
            EList resources = this.egfResourceSet.getResources();
            for (Resource resource : resources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
            }
        }
    }

    private void getPattern(FactoryComponent eObject, Collection<Pattern> patterns) {
        EList viewpoints;
        ViewpointContainer viewpointContainer = eObject.getViewpointContainer();
        if (viewpointContainer != null && !(viewpoints = viewpointContainer.getViewpoints()).isEmpty()) {
            for (Viewpoint viewpoint : viewpoints) {
                if (!(viewpoint instanceof PatternViewpoint)) continue;
                EList libraries = ((PatternViewpoint)viewpoint).getLibraries();
                for (PatternLibrary lib : libraries) {
                    this.getPattern(lib, patterns);
                }
            }
        }
    }

    private void getPattern(PatternLibrary eObject, Collection<Pattern> patterns) {
        EList elements = eObject.getElements();
        for (Pattern pattern : elements) {
            this.getPattern(pattern, patterns);
        }
    }

    private void getPattern(Pattern eObject, Collection<Pattern> patterns) {
        patterns.add(eObject);
    }

    private IDocGenExtensionElement createDocGenExtensionElement(String id, Integer priority, Collection<Pattern> patterns) {
        return new DocGenExtensionElement(id, priority, patterns);
    }
}

