/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util.pattern.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.behavior.AbstractEvent;
import org.polarsys.capella.common.data.modellingcore.IState;
import org.polarsys.capella.core.data.capellacommon.AbstractState;
import org.polarsys.capella.core.data.capellacommon.Region;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.capellacommon.StateTransition;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.semantic.queries.basic.queries.AbstractStateAvailableElements;
import org.polarsys.capella.docgen.util.CapellaServices;
import org.polarsys.capella.docgen.util.StringUtil;

public class CapellaStateHelper {
    public static String getDoActivity(String projectName, String outputFolder, State state) {
        StringBuffer ret = new StringBuffer();
        EList abstractEvents = state.getDoActivity();
        for (AbstractEvent event : abstractEvents) {
            if (event == null) continue;
            StringBuffer buffer = new StringBuffer();
            buffer.append(CapellaServices.getImageLinkFromElement((EObject)event, projectName, outputFolder));
            buffer.append(" ");
            buffer.append(CapellaServices.getHyperlinkFromElement((EObject)event));
            ret.append("<br/>");
            ret.append(buffer);
        }
        return ret.toString();
    }

    public static Collection<String> getOwnedReferencedStatesModes(String projectName, String outputFolder, State state) {
        ArrayList<String> ret = new ArrayList<String>();
        HashMap orderedByRegion = new HashMap();
        for (IState currentStateMode : state.getReferencedStates()) {
            EObject parent;
            if (!CapellaStateHelper.getEObjectPathFromStateMachine((EObject)currentStateMode).contains(state) || !((parent = currentStateMode.eContainer()) instanceof Region)) continue;
            Region region = (Region)parent;
            List list = (List)orderedByRegion.get(region);
            if (list != null) {
                list.add(currentStateMode);
                continue;
            }
            ArrayList<IState> tempList = new ArrayList<IState>();
            tempList.add(currentStateMode);
            orderedByRegion.put(region, tempList);
        }
        for (Region currentRegion : orderedByRegion.keySet()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(CapellaServices.getImageLinkFromElement((EObject)currentRegion, projectName, outputFolder));
            buffer.append(" ");
            buffer.append(CapellaServices.getHyperlinkFromElement((EObject)currentRegion));
            ArrayList<String> subRet = new ArrayList<String>();
            for (IState regionState : (List)orderedByRegion.get(currentRegion)) {
                StringBuffer buffer2 = new StringBuffer();
                buffer2.append(CapellaServices.getImageLinkFromElement((EObject)regionState, projectName, outputFolder));
                buffer2.append(" ");
                buffer2.append(CapellaServices.getHyperlinkFromElement((EObject)regionState));
                subRet.add(buffer2.toString());
            }
            buffer.append(StringUtil.stringListToBulette(subRet));
            ret.add(buffer.toString());
        }
        return ret;
    }

    public static Collection<String> getReferencedStatesModes(String projectName, String outputFolder, State state) {
        ArrayList<String> ret = new ArrayList<String>();
        for (IState currentStateMode : state.getReferencedStates()) {
            if (CapellaStateHelper.getEObjectPathFromStateMachine((EObject)currentStateMode).contains(state)) continue;
            StringBuffer buffer = new StringBuffer();
            buffer.append(CapellaServices.getImageLinkFromElement((EObject)currentStateMode, projectName, outputFolder));
            buffer.append(" ");
            buffer.append(CapellaServices.getHyperlinkFromElement((EObject)currentStateMode));
            buffer.append(" <em><span style=\"font-size:10px; color:#999999\">(");
            buffer.append(CapellaStateHelper.getPathFromStateMachine(currentStateMode));
            buffer.append(")</span></em>");
            ret.add(buffer.toString());
        }
        return ret;
    }

    public static Collection<String> getPreviousStatesModes(String projectName, String outputFolder, State state) {
        ArrayList<String> ret = new ArrayList<String>();
        for (StateTransition currentAbstractStateTransition : state.getIncoming()) {
            AbstractState source = currentAbstractStateTransition.getSource();
            if (source == null) continue;
            StringBuffer buffer = new StringBuffer();
            buffer.append(CapellaServices.getImageLinkFromElement((EObject)source, projectName, outputFolder));
            buffer.append(" ");
            buffer.append(CapellaServices.getHyperlinkFromElement((EObject)source));
            ret.add(buffer.toString());
        }
        return ret;
    }

    public static Collection<String> getFollowingStatesModes(String projectName, String outputFolder, State state) {
        ArrayList<String> ret = new ArrayList<String>();
        for (StateTransition currentAbstractStateTransition : state.getOutgoing()) {
            AbstractState target = currentAbstractStateTransition.getTarget();
            if (target == null) continue;
            StringBuffer buffer = new StringBuffer();
            buffer.append(CapellaServices.getImageLinkFromElement((EObject)target, projectName, outputFolder));
            buffer.append(" ");
            buffer.append(CapellaServices.getHyperlinkFromElement((EObject)target));
            ret.add(buffer.toString());
        }
        return ret;
    }

    public static Collection<String> getFunctions(String projectName, String outputFolder, State state) {
        ArrayList<String> ret = new ArrayList<String>();
        AbstractStateAvailableElements query = new AbstractStateAvailableElements();
        List list = query.compute((Object)state);
        for (Object currentObject : list) {
            if (!(currentObject instanceof AbstractFunction)) continue;
            StringBuffer buffer = new StringBuffer();
            buffer.append(CapellaServices.getImageLinkFromElement((EObject)((AbstractFunction)currentObject), projectName, outputFolder));
            buffer.append(" ");
            buffer.append(CapellaServices.getHyperlinkFromElement((EObject)((AbstractFunction)currentObject)));
            ret.add(buffer.toString());
        }
        return ret;
    }

    public static Collection<String> getFunctionalChain(String projectName, String outputFolder, State state) {
        ArrayList<String> ret = new ArrayList<String>();
        AbstractStateAvailableElements query = new AbstractStateAvailableElements();
        List list = query.compute((Object)state);
        for (Object currentObject : list) {
            if (!(currentObject instanceof FunctionalChain)) continue;
            StringBuffer buffer = new StringBuffer();
            buffer.append(CapellaServices.getImageLinkFromElement((EObject)((FunctionalChain)currentObject), projectName, outputFolder));
            buffer.append(" ");
            buffer.append(CapellaServices.getHyperlinkFromElement((EObject)((FunctionalChain)currentObject)));
            ret.add(buffer.toString());
        }
        return ret;
    }

    public static Collection<String> getCapabilities(String projectName, String outputFolder, State state) {
        ArrayList<String> ret = new ArrayList<String>();
        AbstractStateAvailableElements query = new AbstractStateAvailableElements();
        List list = query.compute((Object)state);
        for (Object currentObject : list) {
            if (!(currentObject instanceof Capability)) continue;
            StringBuffer buffer = new StringBuffer();
            buffer.append(CapellaServices.getImageLinkFromElement((EObject)((Capability)currentObject), projectName, outputFolder));
            buffer.append(" ");
            buffer.append(CapellaServices.getHyperlinkFromElement((EObject)((Capability)currentObject)));
            ret.add(buffer.toString());
        }
        return ret;
    }

    public static String getPathFromStateMachine(IState state) {
        StringBuffer buffer = new StringBuffer();
        Iterator<EObject> iterator = CapellaStateHelper.getEObjectPathFromStateMachine((EObject)state).iterator();
        while (iterator.hasNext()) {
            buffer.append(CapellaServices.getHyperlinkFromElement(iterator.next()));
            if (!iterator.hasNext()) continue;
            buffer.append(" > ");
        }
        return buffer.toString();
    }

    private static List<EObject> getEObjectPathFromStateMachine(EObject element) {
        ArrayList<EObject> eObjects = new ArrayList<EObject>();
        EObject parent = element.eContainer();
        if (parent instanceof StateMachine) {
            eObjects.add(parent);
        } else if (parent instanceof EObject) {
            eObjects.addAll(CapellaStateHelper.getEObjectPathFromStateMachine(parent));
        }
        eObjects.add(element);
        return eObjects;
    }
}

