/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.scope;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.kitalpha.doc.gen.business.core.messages.Messages;
import org.polarsys.kitalpha.doc.gen.business.core.scope.ScopeElementStrategy;
import org.polarsys.kitalpha.doc.gen.business.core.scope.ScopeException;

public class ScopeCompute {
    private ScopeCompute() {
    }

    public static List<EObject> computeScope(EObject modelElement, ScopeElementStrategy strategy) throws ScopeException {
        EObject rootContainer;
        List<EObject> childrenOf;
        List<EObject> parentsOf;
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (modelElement == null) {
            throw new ScopeException(Messages.Scope_Cant_Compute_On_Null_Object);
        }
        boolean addParents = false;
        boolean addChildren = false;
        boolean addCurrent = false;
        switch (strategy) {
            case ALL: {
                addParents = true;
                addChildren = true;
                addCurrent = true;
                break;
            }
            case CHILDREN: {
                addChildren = true;
                addCurrent = true;
                break;
            }
            case PARENT: {
                addParents = true;
                addCurrent = true;
                break;
            }
            case ELEMENT: {
                addCurrent = true;
            }
        }
        if (addParents && !(parentsOf = ScopeCompute.getParentsOf(modelElement)).isEmpty()) {
            result.addAll(parentsOf);
        }
        if (addCurrent) {
            result.add(modelElement);
        }
        if (addChildren && !(childrenOf = ScopeCompute.getChildrenOf(modelElement)).isEmpty()) {
            result.addAll(childrenOf);
        }
        if (!result.contains(rootContainer = EcoreUtil.getRootContainer((EObject)modelElement))) {
            result.add(rootContainer);
        }
        return result;
    }

    private static List<EObject> getChildrenOf(EObject modelElement) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        TreeIterator eAllContents = modelElement.eAllContents();
        while (eAllContents.hasNext()) {
            EObject eObject = (EObject)eAllContents.next();
            result.add(eObject);
        }
        return result;
    }

    private static List<EObject> getParentsOf(EObject modelElement) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        EObject parent = modelElement.eContainer();
        while (parent != null) {
            result.add(parent);
            parent = parent.eContainer();
        }
        return result;
    }
}

