/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.polarsys.capella.core.ui.resources.CapellaUIResourcesPlugin;
import org.polarsys.capella.docgen.Activator;

public class ImageHelper {
    public static ImageHelper INSTANCE = new ImageHelper();
    private static final String ICON_FOLDER_NAME = "icon";
    private static final String FILE_NOT_FOUND = "Image source file doesn't exist";
    private static final String FOLDER_HIERARCHY_CREATION_ERROR = "Cannot Create Target Folder Hierarchy";
    private static final NullProgressMonitor MONITOR = new NullProgressMonitor();
    private static final String PNG = "png";

    private ImageHelper() {
    }

    public void copyProjectImageToSystemLocation(String srcFile, String targetFile) throws IOException {
        File inputFile = new File(srcFile);
        File outputFile = new File(targetFile);
        this.createFoldersHierarchy(outputFile);
        if (inputFile.exists()) {
            this.copyFile(inputFile, outputFile);
        } else {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.docgen", "Image source file doesn't exist: \"" + inputFile.getAbsolutePath() + "\""));
        }
    }

    private void createFoldersHierarchy(File outputFile) {
        File parentFile = outputFile.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.docgen", "Cannot Create Target Folder Hierarchy: \"" + outputFile.getAbsolutePath() + "\""));
        }
    }

    private void copyFile(File sourceFile, File destFile) throws IOException {
        InputStream inputStr = null;
        OutputStream outputStr = null;
        try {
            int bytesRead;
            inputStr = new FileInputStream(sourceFile);
            outputStr = new FileOutputStream(destFile);
            byte[] buf = new byte[1024];
            while ((bytesRead = inputStr.read(buf)) > 0) {
                outputStr.write(buf, 0, bytesRead);
            }
        }
        finally {
            inputStr.close();
            outputStr.close();
        }
    }

    public static String getTypePng(EObject eObject, String projectName, String folderName) {
        String withoutFileExtension;
        IFile iconFileTemp;
        ImageDescriptor imageDescriptor = CapellaUIResourcesPlugin.getDefault().getPNGImage(eObject);
        Image image = null;
        if (imageDescriptor != null) {
            image = imageDescriptor.createImage(true);
        }
        String simpleFileName = CapellaUIResourcesPlugin.getDefault().getCustomizedImageName(eObject);
        IFolder iconFolder = ImageHelper.getIconFolder(projectName, folderName);
        IFile iconFile = iconFolder.getFile(String.valueOf(simpleFileName) + ".png");
        if (!iconFile.exists() && (iconFileTemp = ImageHelper.createNewIconFile(image, withoutFileExtension = iconFile.getLocation().toString().replace(iconFile.getLocation().getFileExtension(), ""))) != null) {
            iconFile = iconFileTemp;
        }
        if (image != null) {
            image.dispose();
        }
        return iconFile.getName();
    }

    private static IFolder getIconFolder(String projectName, String folderName) {
        IPath path = new Path(projectName).append(folderName);
        IContainer parent = ResourcesPlugin.getWorkspace().getRoot().getFolder(path).getParent();
        IPath iconPath = parent.getFullPath().append(ICON_FOLDER_NAME);
        IFolder iconFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(iconPath);
        if (iconFolder == null || !iconFolder.exists()) {
            try {
                FileHelper.createContainers((IProgressMonitor)MONITOR, (IResource)iconFolder);
                iconFolder.create(true, true, (IProgressMonitor)MONITOR);
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.docgen", String.valueOf(folderName) + " can not be created. This can lead to some gaps in the generated documentation. See the exception stack for more details", (Throwable)e));
            }
        }
        return iconFolder;
    }

    private static IFile createNewIconFile(Image iconImage, String fileName) {
        if (iconImage != null) {
            ImageLoader loader = new ImageLoader();
            loader.data = new ImageData[]{iconImage.getImageData()};
            try {
                fileName = String.valueOf(fileName) + PNG;
                loader.save(fileName, 5);
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.docgen", String.valueOf(fileName) + " can not be saved. This can lead to some gaps in the generated documentation. See the exception stack for more details", (Throwable)e));
            }
            return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileName));
        }
        return null;
    }
}

