/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.validation.functionalChain;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import org.eclipse.emf.common.util.EList;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.vp.ms.CSConfiguration;

public final class FunctionalChainAnalysisResult {
    private FunctionalChain fc;
    private State state;
    private Component component;
    private CSConfiguration configuration;
    private EList<AbstractFunction> missingFunctions;

    public FunctionalChainAnalysisResult(FunctionalChain fc, State state, Component component, CSConfiguration configuration, EList<AbstractFunction> commonFunctions) {
        this.fc = fc;
        this.state = state;
        this.component = component;
        this.configuration = configuration;
        this.missingFunctions = commonFunctions;
    }

    public FunctionalChain getFc() {
        return this.fc;
    }

    public void setFc(FunctionalChain fc) {
        this.fc = fc;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public CSConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CSConfiguration configuration) {
        this.configuration = configuration;
    }

    public EList<AbstractFunction> getMissingFunctions() {
        return this.missingFunctions;
    }

    public void setMissingFunctions(EList<AbstractFunction> missingFunctions) {
        this.missingFunctions = missingFunctions;
    }

    public String toReadableString() {
        if (this.getMissingFunctions() != null && this.getMissingFunctions().size() > 0) {
            return "The functional chain '" + this.getFc().getName() + "' is not assured in the State/Mode '" + this.getState().getName() + "' of the Component '" + this.getComponent().getName() + "' because the functions '" + Joiner.on((String)", ").join((Iterable)Collections2.transform(this.getMissingFunctions(), (Function)new Function<NamedElement, String>(){

                public String apply(NamedElement o) {
                    return o.getName();
                }
            })) + "' are not available in the configuration '" + this.getConfiguration().getName() + "'.";
        }
        return "The functional chain '" + this.getFc().getName() + "' is not assured in the State/Mode '" + this.getState().getName() + "' of the Component '" + this.getComponent().getName() + "' because no configuration is selected in that State/Mode.";
    }
}

