/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.validation.functionalChain;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.common.statemachine.validation.StateMachineUtils;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.validation.functionalChain.FunctionalAnalysisUtils;
import org.polarsys.capella.core.data.fa.validation.functionalChain.FunctionalChainAnalysisResult;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class StateModeFunctionalChain
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        State state = (State)ctx.getTarget();
        StateMachine stateMachine = StateMachineUtils.getStateMachine(state);
        Component component = StateMachineUtils.getComponent(stateMachine);
        EList<FunctionalChain> fcInvolvers = FunctionalAnalysisUtils.getFunctionalChainInvolvers(component);
        ArrayList<FunctionalChainAnalysisResult> results = new ArrayList<FunctionalChainAnalysisResult>();
        for (FunctionalChain fc : fcInvolvers) {
            EList<AbstractFunction> commonFunctions = FunctionalAnalysisUtils.getCommonFunctions(component, fc);
            results.addAll(FunctionalAnalysisUtils.analyzeFC_State(fc, state, component, commonFunctions));
        }
        if (results.size() > 0) {
            ArrayList<IStatus> children = new ArrayList<IStatus>();
            for (FunctionalChainAnalysisResult result : results) {
                children.add(ctx.createFailureStatus(new Object[]{result.toReadableString()}));
            }
            return ConstraintStatus.createMultiStatus((IValidationContext)ctx, children);
        }
        return ctx.createSuccessStatus();
    }
}

