/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.jvmmodel.findrefs;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.jdt.internal.ui.search.JavaSearchResult;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.RemoveAllEvent;
import org.eclipse.xtext.xbase.ui.jvmmodel.findrefs.CompositeSearchQuery;

public class CompositeSearchResult
extends JavaSearchResult {
    private CompositeSearchQuery query;
    private ISearchResultListener childListener;

    public CompositeSearchResult(CompositeSearchQuery compositeSearchQuery) {
        super((JavaSearchQuery)compositeSearchQuery);
        this.query = compositeSearchQuery;
        Assert.isLegal((!this.query.getChildren().isEmpty() ? 1 : 0) != 0);
        this.childListener = new ISearchResultListener(){
            int removeAll = 0;

            public void searchResultChanged(SearchResultEvent e) {
                if (!(e instanceof RemoveAllEvent) || this.removeAll++ % CompositeSearchResult.this.query.getChildren().size() == 0) {
                    CompositeSearchResult.this.fireChange(e);
                }
            }
        };
        for (ISearchQuery child : this.query.getChildren()) {
            child.getSearchResult().addListener(this.childListener);
        }
    }

    public int getMatchCount(Object element) {
        int count = 0;
        for (ISearchQuery child : this.query.getChildren()) {
            ISearchResult childResult = child.getSearchResult();
            if (!(childResult instanceof AbstractTextSearchResult)) continue;
            count += ((AbstractTextSearchResult)childResult).getMatchCount(element);
        }
        return count;
    }

    public int getMatchCount() {
        int count = 0;
        for (ISearchQuery child : this.query.getChildren()) {
            ISearchResult childResult = child.getSearchResult();
            if (!(childResult instanceof AbstractTextSearchResult)) continue;
            count += ((AbstractTextSearchResult)childResult).getMatchCount();
        }
        return count;
    }

    public Match[] getMatches(Object element) {
        ArrayList matches = Lists.newArrayList();
        for (ISearchQuery child : this.query.getChildren()) {
            ISearchResult childResult = child.getSearchResult();
            if (!(childResult instanceof AbstractTextSearchResult)) continue;
            Match[] matchArray = ((AbstractTextSearchResult)childResult).getMatches(element);
            int n = matchArray.length;
            int n2 = 0;
            while (n2 < n) {
                Match match = matchArray[n2];
                matches.add(match);
                ++n2;
            }
        }
        return (Match[])Iterables.toArray((Iterable)matches, Match.class);
    }
}

