/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.scenario.editor.dsl.formatting2;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.polarsys.capella.scenario.editor.dsl.services.TextualScenarioGrammarAccess;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Block;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Element;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Message;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Model;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Operand;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Participant;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Reference;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.StateFragment;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.TextualScenarioPackage;

public class TextualScenarioFormatter
extends AbstractFormatter2 {
    @Inject
    @Extension
    private TextualScenarioGrammarAccess _textualScenarioGrammarAccess;

    protected void _format(Model model, @Extension IFormattableDocument document) {
        ISemanticRegion begin = this.textRegionExtensions.regionFor((EObject)model).feature((EStructuralFeature)TextualScenarioPackage.Literals.MODEL__BEGIN);
        ISemanticRegion end = this.textRegionExtensions.regionFor((EObject)model).feature((EStructuralFeature)TextualScenarioPackage.Literals.MODEL__END);
        Procedures.Procedure1 _function = it -> it.noSpace();
        document.prepend(begin, _function);
        Procedures.Procedure1 _function_1 = it -> it.newLine();
        document.append(begin, _function_1);
        Procedures.Procedure1 _function_2 = it -> it.indent();
        document.interior(begin, end, _function_2);
        Consumer<Participant> _function_3 = element -> document.format(element);
        model.getParticipants().forEach(_function_3);
        Consumer<Element> _function_4 = element -> document.format(element);
        model.getElements().forEach(_function_4);
    }

    protected void _format(Message message, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.append(this.textRegionExtensions.regionFor((EObject)message).feature((EStructuralFeature)TextualScenarioPackage.Literals.MESSAGE__NAME), _function);
    }

    protected void _format(Participant participant, @Extension IFormattableDocument document) {
        ISemanticRegion p = this.textRegionExtensions.regionFor((EObject)participant).feature((EStructuralFeature)TextualScenarioPackage.Literals.PARTICIPANT__NAME);
        Procedures.Procedure1 _function = it -> it.newLine();
        document.append(this.textRegionExtensions.regionFor((EObject)participant).feature((EStructuralFeature)TextualScenarioPackage.Literals.PARTICIPANT__NAME), _function);
    }

    protected void _format(CombinedFragment fragment, @Extension IFormattableDocument document) {
        this.format(fragment.getBlock(), document);
        Consumer<Operand> _function = element -> document.format(element);
        fragment.getOperands().forEach(_function);
        Procedures.Procedure1 _function_1 = it -> it.newLine();
        document.append((EObject)fragment, _function_1);
    }

    protected void _format(Operand operand, @Extension IFormattableDocument document) {
        this.format(operand.getBlock(), document);
    }

    protected void _format(Block block, @Extension IFormattableDocument document) {
        ISemanticRegion begin = this.textRegionExtensions.regionFor((EObject)block).feature((EStructuralFeature)TextualScenarioPackage.Literals.BLOCK__BEGIN);
        ISemanticRegion end = this.textRegionExtensions.regionFor((EObject)block).feature((EStructuralFeature)TextualScenarioPackage.Literals.BLOCK__END);
        Procedures.Procedure1 _function = it -> it.newLine();
        document.append(begin, _function);
        Procedures.Procedure1 _function_1 = it -> it.indent();
        document.interior(begin, end, _function_1);
        Consumer<Element> _function_2 = element -> document.format(element);
        block.getBlockElements().forEach(_function_2);
    }

    protected void _format(StateFragment stateFragment, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.append(this.textRegionExtensions.regionFor((EObject)stateFragment).feature((EStructuralFeature)TextualScenarioPackage.Literals.STATE_FRAGMENT__NAME), _function);
    }

    protected void _format(Reference reference, @Extension IFormattableDocument document) {
        List features = this.textRegionExtensions.regionFor((EObject)reference).features(new EStructuralFeature[]{TextualScenarioPackage.Literals.REFERENCE__TIMELINES});
        int _size = features.size();
        int _minus = _size - 1;
        Procedures.Procedure1 _function = it -> it.newLine();
        document.append((ISemanticRegion)features.get(_minus), _function);
    }

    public void format(Object fragment, IFormattableDocument document) {
        if (fragment instanceof XtextResource) {
            this._format((XtextResource)fragment, document);
            return;
        }
        if (fragment instanceof CombinedFragment) {
            this._format((CombinedFragment)fragment, document);
            return;
        }
        if (fragment instanceof Message) {
            this._format((Message)fragment, document);
            return;
        }
        if (fragment instanceof Reference) {
            this._format((Reference)fragment, document);
            return;
        }
        if (fragment instanceof StateFragment) {
            this._format((StateFragment)fragment, document);
            return;
        }
        if (fragment instanceof Block) {
            this._format((Block)fragment, document);
            return;
        }
        if (fragment instanceof Model) {
            this._format((Model)fragment, document);
            return;
        }
        if (fragment instanceof Operand) {
            this._format((Operand)fragment, document);
            return;
        }
        if (fragment instanceof Participant) {
            this._format((Participant)fragment, document);
            return;
        }
        if (fragment instanceof EObject) {
            this._format((EObject)fragment, document);
            return;
        }
        if (fragment == null) {
            this._format(null, document);
            return;
        }
        if (fragment != null) {
            this._format(fragment, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(fragment, document).toString());
    }
}

