/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.importer.transposer.activities;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.ui.specification.ext.ResourceScopeDefinition;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.datatypes.DatatypesPackage;
import org.eclipse.rmf.reqif10.serialization.ReqIF10ResourceFactoryImpl;
import org.eclipse.rmf.reqif10.xhtml.XhtmlPackage;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.transition.common.activities.AbstractActivity;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class InitializeTransformation
extends AbstractActivity {
    public static final String getId() {
        return InitializeTransformation.class.getCanonicalName();
    }

    protected IStatus _run(ActivityParameters activityParams) {
        IContext context = (IContext)activityParams.getParameter("TransposerContext").getValue();
        IStatus loadSourceStatus = this.loadSourceScope(context);
        if (!this.checkStatus(loadSourceStatus)) {
            return loadSourceStatus;
        }
        IStatus loadTargetStatus = this.loadTransformationScope(context);
        if (!this.checkStatus(loadTargetStatus)) {
            return loadTargetStatus;
        }
        return Status.OK_STATUS;
    }

    protected IStatus loadTransformationScope(IContext context) {
        BlockArchitecture target = (BlockArchitecture)context.get((Object)"TARGET_ELEMENT");
        ResourceScopeDefinition definition = new ResourceScopeDefinition(target.eResource(), InitializeTransformation.getId(), false);
        IEditableModelScope targetScope = definition.createScope(definition.getEntrypoint());
        context.put((Object)"TARGET_SCOPE", (Object)targetScope);
        return Status.OK_STATUS;
    }

    protected IStatus loadSourceScope(IContext context) {
        ExecutionManager manager = ExecutionManagerRegistry.getInstance().addNewManager();
        ResourceSet resourceSet = manager.getEditingDomain().getResourceSet();
        resourceSet.getPackageRegistry().put((Object)ReqIF10Package.eINSTANCE.getNsURI(), (Object)ReqIF10Package.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)XhtmlPackage.eINSTANCE.getNsURI(), (Object)XhtmlPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)DatatypesPackage.eINSTANCE.getNsURI(), (Object)DatatypesPackage.eINSTANCE);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new ReqIF10ResourceFactoryImpl());
        URI uri = (URI)context.get((Object)"CONTEXT_MODEL");
        Resource resource = resourceSet.getResource(uri, true);
        ResourceScopeDefinition definition = new ResourceScopeDefinition(resource, InitializeTransformation.getId(), false);
        IEditableModelScope sourceScope = definition.createScope(definition.getEntrypoint());
        context.put((Object)"SOURCE_SCOPE", (Object)sourceScope);
        return this.checkErrors((EList<Resource.Diagnostic>)resource.getErrors());
    }

    private IStatus checkErrors(EList<Resource.Diagnostic> errors) {
        if (errors == null || errors.isEmpty()) {
            return Status.OK_STATUS;
        }
        if (errors.size() == 1) {
            return new Status(4, "org.polarsys.capella.vp.requirements.importer", 0, ((Resource.Diagnostic)errors.get(0)).getMessage(), this.safeCast((Resource.Diagnostic)errors.get(0)));
        }
        MultiStatus statii = new MultiStatus("org.polarsys.capella.vp.requirements.importer", 0, "Errors while loading ReqIF file", null);
        for (Resource.Diagnostic diagnostic : errors) {
            statii.add((IStatus)new Status(4, "org.polarsys.capella.vp.requirements.importer", 0, diagnostic.getMessage(), this.safeCast(diagnostic)));
        }
        return statii;
    }

    private Throwable safeCast(Resource.Diagnostic diagnostic) {
        if (diagnostic instanceof Throwable) {
            return (Throwable)diagnostic;
        }
        return null;
    }
}

