/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ju.testcases;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonNavigatorManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.utils.ScopeModelWrapper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.view.CapellaCommonNavigator;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class PropertyViewTestCase
extends BasicTestCase {
    private static final String projectTestName = "misc";
    private static final String CAPELLA_MODULE = "92115d8a-4cf0-4b63-8200-a7043e201ea0";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(projectTestName);
    }

    public void test() throws Exception {
        CapellaModel model = this.getTestModel(projectTestName);
        ScopeModelWrapper scope = new ScopeModelWrapper((IModel)model);
        EObject capellaModule = IdManager.getInstance().getEObject(CAPELLA_MODULE, (IScope)scope);
        this.activatePropertyView();
        this.selectOnNavigatorView(capellaModule);
    }

    private void selectOnNavigatorView(EObject selectedObject) {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            activePage.showView("capella.project.explorer");
            CapellaCommonNavigator navigatorview = (CapellaCommonNavigator)activePage.findView("capella.project.explorer");
            CommonNavigatorManager manager = new CommonNavigatorManager((CommonNavigator)navigatorview);
            manager.selectionChanged(new SelectionChangedEvent((ISelectionProvider)navigatorview.getCommonViewer(), (ISelection)new StructuredSelection((Object)selectedObject)));
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    private void activatePropertyView() {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            activePage.showView("org.eclipse.ui.views.PropertySheet");
            IViewPart propertyView = activePage.findView("org.eclipse.ui.views.PropertySheet");
            activePage.activate((IWorkbenchPart)propertyView);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }
}

