/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ui.importer.preferences;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.common.helpers.operations.LongRunningListenersRegistry;
import org.polarsys.capella.core.commands.preferences.service.AbstractDefaultPreferencePage;
import org.polarsys.capella.vp.requirements.importer.preferences.RequirementsPreferencesPlugin;

public class RequirementsPreferencePage
extends AbstractDefaultPreferencePage {
    public RequirementsPreferencePage() {
        this.setPreferenceStore(RequirementsPreferencesPlugin.getDefault().getPreferenceStore());
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return RequirementsPreferencesPlugin.getDefault().getPreferenceStore();
    }

    public boolean performOk() {
        boolean result = false;
        try {
            LongRunningListenersRegistry.getInstance().operationStarting(((Object)((Object)this)).getClass());
            result = super.performOk();
        }
        finally {
            LongRunningListenersRegistry.getInstance().operationEnded(((Object)((Object)this)).getClass());
        }
        return result;
    }

    protected void createFieldEditors() {
        super.createFieldEditors();
        Composite parentGroup = new Composite(this.getFieldEditorParent(), 0);
        parentGroup.setLayout((Layout)new GridLayout(1, false));
        this.createRequirementFieldEditors(parentGroup);
        this.createEnumerationValueFieldEditors(parentGroup);
        this.createOtherFieldEditors(parentGroup);
    }

    private void createRequirementFieldEditors(Composite parentGroup) {
        Group reqGroup = this.createGroup("Requirements", "Requirement Preferences", parentGroup);
        StringFieldEditor reqLabelExpressionEditor = new StringFieldEditor("requirement.label.expression", "Label Expression", 80, 4, 0, (Composite)reqGroup);
        this.addField((FieldEditor)reqLabelExpressionEditor);
        StringFieldEditor reqLabelMaxLenEditor = new StringFieldEditor("requirement.label.max.len", "Label Max Length (leave empty for full text)", (Composite)reqGroup);
        reqLabelMaxLenEditor.getTextControl((Composite)reqGroup).addModifyListener((ModifyListener)new NumberFieldModifyListener((Control)reqLabelMaxLenEditor.getTextControl((Composite)reqGroup)));
        this.addField((FieldEditor)reqLabelMaxLenEditor);
    }

    private void createEnumerationValueFieldEditors(Composite parentGroup) {
        Group enumGroup = this.createGroup("Enumeration Value Attributes", "Enumeration Value Attribute Preferences", parentGroup);
        StringFieldEditor enumValueLabelMaxLenEditor = new StringFieldEditor("value.label.max.len", "Label Max Length (leave empty for full text)", (Composite)enumGroup);
        enumValueLabelMaxLenEditor.getTextControl((Composite)enumGroup).addModifyListener((ModifyListener)new NumberFieldModifyListener((Control)enumValueLabelMaxLenEditor.getTextControl((Composite)enumGroup)));
        this.addField((FieldEditor)enumValueLabelMaxLenEditor);
    }

    private void createOtherFieldEditors(Composite parentGroup) {
        Group otherGroup = this.createGroup("Other configuration items", "", parentGroup);
        BooleanFieldEditor forceDoorsRmfUsageEditor = new BooleanFieldEditor("requirement.label.doors.rmf", "Force DOORS RMF usage check while importing requirements", (Composite)otherGroup);
        this.addField((FieldEditor)forceDoorsRmfUsageEditor);
    }

    protected String getPageTitle() {
        return "Requirements";
    }

    protected String getPageDescription() {
        return "Preferences related to Requirements";
    }

    class NumberFieldModifyListener
    implements ModifyListener {
        ControlDecoration decorator;

        public NumberFieldModifyListener(Control control) {
            this.decorator = new ControlDecoration(control, 0x1000000);
            this.decorator.setDescriptionText("Not a valid number");
            Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
            this.decorator.setImage(image);
            this.decorator.hide();
        }

        public void modifyText(ModifyEvent event) {
            String text = ((Text)event.getSource()).getText();
            if (!text.matches("\\d*")) {
                this.decorator.show();
                RequirementsPreferencePage.this.setValid(false);
            } else {
                this.decorator.hide();
                RequirementsPreferencePage.this.setValid(true);
            }
        }
    }
}

