/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ui.commands;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.vp.requirements.ui.commands.ReqVPConfigureDialog;
import org.polarsys.capella.vp.requirements.ui.commands.ReqVPCustomDataHelper;
import org.polarsys.capella.vp.requirements.ui.commands.SaveQueriesCommand;

public class ReqVPConfigureCommandHandler
implements IHandler {
    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        SystemEngineering selectedSystemEngineering = null;
        try {
            ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
            ITreeSelection selection = (ITreeSelection)selectionService.getSelection();
            selectedSystemEngineering = (SystemEngineering)selection.getFirstElement();
        }
        catch (Exception e) {
            selectedSystemEngineering = null;
        }
        if (selectedSystemEngineering != null) {
            Session session = SessionManager.INSTANCE.getSession(selectedSystemEngineering);
            String labelExpression = null;
            String labelMaxLength = null;
            String contentExpression = null;
            String contentMaxLength = null;
            EAnnotation queriesAnnotation = ReqVPCustomDataHelper.getCustomData(session);
            if (queriesAnnotation == null) {
                queriesAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            } else {
                labelExpression = (String)queriesAnnotation.getDetails().get((Object)"REQUIREMENTS_VP_LABEL_QUERY");
                labelMaxLength = (String)queriesAnnotation.getDetails().get((Object)"REQUIREMENTS_VP_LABEL_LENGTH");
                contentExpression = (String)queriesAnnotation.getDetails().get((Object)"REQUIREMENTS_VP_CONTENT_QUERY");
                contentMaxLength = (String)queriesAnnotation.getDetails().get((Object)"REQUIREMENTS_VP_CONTENT_LENGTH");
            }
            ReqVPConfigureDialog dialog = new ReqVPConfigureDialog(Display.getCurrent().getActiveShell(), labelExpression, contentExpression, labelMaxLength, contentMaxLength);
            dialog.create();
            if (dialog.open() == 0) {
                TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
                domain.getCommandStack().execute((Command)new SaveQueriesCommand(domain, session, queriesAnnotation, dialog.getLabelExpression(), dialog.getContentExpression(), dialog.getLabelMaxLength(), dialog.getContentMaxLength()));
            }
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

