/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.reqif.resource.obfuscator;

import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.lib.IdGenerator;
import org.polarsys.capella.vp.requirements.reqif.resource.obfuscator.ResourceObfuscatorPlugin;

public class ResourceObfuscatorCommand
extends AbstractReadWriteCommand {
    private Resource resource;

    public ResourceObfuscatorCommand(Resource resource) {
        this.resource = resource;
    }

    public void run() {
        if (this.resource != null) {
            this.obfuscateResource(this.resource);
            this.resource = null;
        }
    }

    protected void obfuscateResource(Resource resource) {
        TreeIterator allContents = resource.getAllContents();
        while (allContents.hasNext()) {
            EObject currentObject = (EObject)allContents.next();
            if (currentObject == null || currentObject.eIsProxy()) continue;
            this.obfuscateElement(currentObject);
        }
    }

    protected void obfuscateElement(EObject object) {
        if (object.eClass() != null) {
            for (EAttribute attribute : object.eClass().getEAllAttributes()) {
                if (!this.isEMFObfuscableEAttribute(object, attribute) || !this.isObfuscationAllowedOnEAttribute(object, attribute)) continue;
                this.obfuscateEAttribute(object, attribute);
            }
        }
    }

    protected boolean isEMFObfuscableEAttribute(EObject object, EAttribute attribute) {
        if (!attribute.isChangeable()) {
            return false;
        }
        if (attribute.isDerived()) {
            return false;
        }
        if (attribute.isTransient()) {
            return false;
        }
        EAttribute attributeId = object.eClass().getEIDAttribute();
        return attributeId == null || !attributeId.equals(attribute);
    }

    protected boolean isObfuscationAllowedOnEAttribute(EObject object, EAttribute attribute) {
        return !(ReqIF10Package.Literals.IDENTIFIABLE__LONG_NAME.equals(attribute) ? ReqIF10Package.Literals.ATTRIBUTE_DEFINITION.isInstance((Object)object) || ReqIF10Package.Literals.DATATYPE_DEFINITION.isInstance((Object)object) : ReqIF10Package.Literals.ATTRIBUTE_VALUE_ENUMERATION__VALUES.equals(attribute));
    }

    protected void obfuscateEAttribute(EObject currentObject, EAttribute attribute) {
        try {
            Object value = currentObject.eGet((EStructuralFeature)attribute);
            if (!attribute.isMany() && value instanceof String) {
                currentObject.eSet((EStructuralFeature)attribute, (Object)this.generateUnreadableString((String)value));
            } else if (attribute.isMany() && value instanceof EList) {
                Iterator itList = ((EList)value).iterator();
                int i = 0;
                while (itList.hasNext()) {
                    Object itValue;
                    Object itElement = itList.next();
                    if (itElement instanceof String) {
                        ((EList)value).set(i, (Object)this.generateUnreadableString((String)itElement));
                    } else if (itElement instanceof EStructuralFeatureImpl.SimpleFeatureMapEntry && (itValue = ((EStructuralFeatureImpl.SimpleFeatureMapEntry)itElement).getValue()) instanceof String) {
                        ((FeatureMap)value).setValue(i, (Object)this.generateUnreadableString((String)itValue));
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            ResourceObfuscatorPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.polarsys.capella.vp.requirements.reqif.resource.obfuscator", "Error during obfuscation of an attribute", (Throwable)exception));
        }
    }

    protected String generateUnreadableString(String uncrypted) {
        if (uncrypted == null) {
            return null;
        }
        if ("".equals(uncrypted)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        String createId = IdGenerator.createId();
        int i = 0;
        int j = 0;
        while (i < uncrypted.length()) {
            if (j >= createId.length()) {
                j = 0;
            }
            builder.append(createId.charAt(j));
            ++i;
            ++j;
        }
        return builder.toString();
    }
}

