/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.importer.commandline;

import java.io.FileNotFoundException;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.polarsys.capella.core.commandline.core.AbstractCommandLine;
import org.polarsys.capella.core.commandline.core.CommandLineException;

public class RequirementsImporterCommandline
extends AbstractCommandLine {
    public void parseContext(IApplicationContext context) throws CommandLineException {
        super.parseContext(context);
    }

    public void printHelp() {
        System.out.println("Capella Requirements Command Line Importer");
        super.printHelp();
    }

    public void checkArgs(IApplicationContext context) throws CommandLineException {
        super.checkArgs(context);
    }

    public void prepare(IApplicationContext context) throws CommandLineException {
        super.prepare(context);
    }

    public boolean execute(IApplicationContext context) throws CommandLineException {
        boolean status;
        String fileURI = "platform:/resource/" + this.argHelper.getFilePath();
        URI uri = URI.createURI((String)fileURI);
        String outputFolder = this.argHelper.getOutputFolder();
        try {
            status = this.execute(uri, outputFolder);
        }
        catch (FileNotFoundException exception) {
            this.logError(exception.getMessage());
            throw new CommandLineException(exception.getMessage());
        }
        catch (CoreException exception) {
            this.logError(exception.getMessage());
            throw new CommandLineException(exception.getMessage());
        }
        if (status) {
            this.logInfo("validation report generated to:  " + this.argHelper.getOutputFolder());
        }
        return false;
    }

    private boolean execute(URI uri, String outputFolder) throws FileNotFoundException, CoreException, CommandLineException {
        this.loadAirdSemanticModel(uri);
        return true;
    }

    private Resource loadAirdSemanticModel(URI uri) {
        SessionManager sessionManager = SessionManager.INSTANCE;
        Session session = sessionManager.getSession(uri, (IProgressMonitor)new NullProgressMonitor());
        Collection resources = session.getSemanticResources();
        if (!resources.isEmpty()) {
            Resource semanticResource = (Resource)resources.iterator().next();
            return semanticResource;
        }
        return null;
    }
}

