/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.interactive.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.swt.widgets.Display;

public class BlockProgressMonitor
extends ProgressMonitorWrapper {
    protected final Display _display;
    protected BlockProgress _block;

    public BlockProgressMonitor(IProgressMonitor monitor_p, Display display_p) {
        super(monitor_p);
        this._display = display_p;
    }

    public void beginTask(final String name_p, final int totalWork_p) {
        this._block = new BlockProgress(this.getWrappedProgressMonitor(), 0);
        this._display.asyncExec(new Runnable(){

            @Override
            public void run() {
                BlockProgressMonitor.this.getWrappedProgressMonitor().beginTask(name_p, totalWork_p);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subTask(String name_p) {
        if (this._block == null) {
            this._block = new BlockProgress(this.getWrappedProgressMonitor(), 0);
        }
        BlockProgress blockProgress = this._block;
        synchronized (blockProgress) {
            this._block.subTask(name_p);
        }
    }

    public void worked(int work_p) {
        this.internalWorked(work_p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalWorked(int work_p) {
        this._block.worked(work_p);
        BlockProgress blockProgress = this._block;
        synchronized (blockProgress) {
            if (this._block._ticks >= 10) {
                this._display.asyncExec((Runnable)this._block);
                this._block = null;
            }
        }
    }

    public void setTaskName(final String name_p) {
        this._display.asyncExec(new Runnable(){

            @Override
            public void run() {
                BlockProgressMonitor.this.getWrappedProgressMonitor().setTaskName(name_p);
            }
        });
    }

    public void done() {
        this._display.asyncExec(new Runnable(){

            @Override
            public void run() {
                BlockProgressMonitor.this.getWrappedProgressMonitor().done();
            }
        });
        this._block = null;
    }

    private class BlockProgress
    implements Runnable {
        private static final int PROGRESS_BLOCK_SIZE = 10;
        protected int _ticks;
        private IProgressMonitor _monitor;
        private String _subTask;

        public BlockProgress(IProgressMonitor monitor_p, int worked_p) {
            this._monitor = monitor_p;
            this._ticks = worked_p;
        }

        public void worked(int additionalWork_p) {
            this._ticks += additionalWork_p;
        }

        public void subTask(String subTaskName_p) {
            this._subTask = subTaskName_p;
        }

        @Override
        public void run() {
            this._monitor.subTask(this._subTask);
            this._monitor.internalWorked((double)this._ticks);
        }
    }
}

