/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.importer.transposer.bridge;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.ImageImportStrategy;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.ImageImporter;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.Messages;

public class ImageImportingDialog
extends TitleAreaDialog {
    private Text absPathText;
    private Button absPathChoosingButton;
    private Text relativePathText;
    private Button relativePathChoosingButton;
    private Button embedImageButton;
    private ImageImporter imageImporter;
    private IProject currentProject;

    protected ImageImportingDialog(Shell parentShell, ImageImporter imageImporter, IProject currentProject) {
        super(parentShell);
        this.imageImporter = imageImporter;
        this.currentProject = currentProject;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(container);
        Composite importingModesComposite = new Composite(container, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)importingModesComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).margins(0, 0).applyTo(importingModesComposite);
        this.setUpAbsPathUI(container, importingModesComposite);
        this.setUpRelPathUI(container, importingModesComposite);
        this.setUpEmbeddedModeUI(importingModesComposite);
        return container;
    }

    protected void setUpEmbeddedModeUI(Composite importingModesComposite) {
        this.embedImageButton = new Button(importingModesComposite, 16);
        this.embedImageButton.setText("Encode image in Base64 and embed it in the text");
        this.embedImageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageImportingDialog.this.embedImageButton.setSelection(true);
                ImageImportingDialog.this.setEnableAbsImagePath(false);
                ImageImportingDialog.this.setEnableRelativeImagePath(false);
                this.enableFinishForEmbeddedImg();
            }

            protected void enableFinishForEmbeddedImg() {
                ImageImportingDialog.this.setMessage(String.valueOf(Messages.ImageImportingDialog_DefaultMessage) + Messages.ImageImportingDialog_EmbeddedMessage);
                ImageImportingDialog.this.getButton(0).setEnabled(true);
                ImageImportingDialog.this.imageImporter.setImgImportStrategy(ImageImportStrategy.EMBEDDED);
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.embedImageButton);
    }

    protected void setUpRelPathUI(final Composite container, Composite importingModesComposite) {
        this.relativePathChoosingButton = new Button(importingModesComposite, 16);
        this.relativePathChoosingButton.setText("Choose a path to image folder that is relative to the current project:");
        this.relativePathChoosingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageImportingDialog.this.setEnableRelativeImagePath(true);
                ImageImportingDialog.this.setEnableAbsImagePath(false);
                ImageImportingDialog.this.embedImageButton.setSelection(false);
                String currentProjectLocation = ImageImportingDialog.this.currentProject.getLocation().toString();
                Path currentProjectPath = Paths.get(currentProjectLocation, new String[0]);
                if (!currentProjectPath.resolve(ImageImportingDialog.this.relativePathText.getText()).toFile().exists()) {
                    ImageImportingDialog.this.disableFinish();
                } else {
                    ImageImportingDialog.this.enableFinishForRelPath();
                }
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.relativePathChoosingButton);
        this.relativePathText = new Text(importingModesComposite, 2052);
        this.relativePathText.addModifyListener(e -> {
            String currentProjectLocation = this.currentProject.getLocation().toString();
            Path currentProjectPath = Paths.get(currentProjectLocation, new String[0]);
            if (!currentProjectPath.resolve(this.relativePathText.getText()).toFile().exists()) {
                this.setErrorMessage("The relative path does not point to a valid folder.");
                this.disableFinish();
            } else {
                this.enableFinishForRelPath();
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.relativePathText);
        Button relativePathBrowseButton = new Button(importingModesComposite, 8);
        relativePathBrowseButton.setText("Browse...");
        relativePathBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(container.getShell());
                String currentProjectLocation = ImageImportingDialog.this.currentProject.getLocation().toString();
                dialog.setFilterPath(currentProjectLocation);
                String result = dialog.open();
                if (result != null) {
                    Path currentProjectPath;
                    Path resultPath = Paths.get(result, new String[0]);
                    if (resultPath.startsWith(currentProjectPath = Paths.get(currentProjectLocation, new String[0]))) {
                        Path relativizedPath = currentProjectPath.relativize(resultPath);
                        ImageImportingDialog.this.relativePathText.setText(relativizedPath.toString());
                    } else {
                        ImageImportingDialog.this.relativePathText.setText("");
                    }
                }
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)relativePathBrowseButton);
        this.setEnableRelativeImagePath(false);
    }

    protected void setUpAbsPathUI(final Composite container, Composite importingModesComposite) {
        this.absPathChoosingButton = new Button(importingModesComposite, 16);
        this.absPathChoosingButton.setText("Choose an absolute path to image folder:");
        this.absPathChoosingButton.setSelection(true);
        this.absPathChoosingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageImportingDialog.this.setEnableAbsImagePath(true);
                ImageImportingDialog.this.setEnableRelativeImagePath(false);
                ImageImportingDialog.this.embedImageButton.setSelection(false);
                if (Paths.get(ImageImportingDialog.this.absPathText.getText(), new String[0]).toFile().exists() && Paths.get(ImageImportingDialog.this.absPathText.getText(), new String[0]).isAbsolute()) {
                    ImageImportingDialog.this.enableFinishForAbsPath();
                } else {
                    ImageImportingDialog.this.setMessage(String.valueOf(Messages.ImageImportingDialog_DefaultMessage) + Messages.ImageImportingDialog_AbsPathMessage);
                    ImageImportingDialog.this.disableFinish();
                }
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.absPathChoosingButton);
        this.absPathText = new Text(importingModesComposite, 2052);
        this.absPathText.addModifyListener(e -> {
            if (Paths.get(this.absPathText.getText(), new String[0]).toFile().exists() && Paths.get(this.absPathText.getText(), new String[0]).isAbsolute()) {
                this.enableFinishForAbsPath();
            } else {
                this.setErrorMessage("The absolute path does not point to a valid folder.");
                this.disableFinish();
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.absPathText);
        Button absPathBrowseButton = new Button(importingModesComposite, 8);
        absPathBrowseButton.setText("Browse...");
        absPathBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(container.getShell());
                String result = dialog.open();
                if (result != null) {
                    ImageImportingDialog.this.absPathText.setText(result);
                }
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)absPathBrowseButton);
    }

    protected void enableFinishForAbsPath() {
        this.setMessage(String.valueOf(Messages.ImageImportingDialog_DefaultMessage) + Messages.ImageImportingDialog_AbsPathMessage);
        this.setErrorMessage(null);
        this.getButton(0).setEnabled(true);
        this.imageImporter.setImgImportStrategy(ImageImportStrategy.ABS_PATH);
        this.imageImporter.setAbsPath(this.absPathText.getText());
    }

    protected void enableFinishForRelPath() {
        this.setMessage(String.valueOf(Messages.ImageImportingDialog_DefaultMessage) + Messages.ImageImportingDialog_RelPathMessage);
        this.setErrorMessage(null);
        this.getButton(0).setEnabled(true);
        this.imageImporter.setImgImportStrategy(ImageImportStrategy.REL_PATH);
        this.imageImporter.setRelPath(this.relativePathText.getText());
    }

    protected void disableFinish() {
        this.getButton(0).setEnabled(false);
        this.imageImporter.setImgImportStrategy(null);
        this.imageImporter.setAbsPath(null);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialSize() {
        return new Point(1000, 320);
    }

    public void create() {
        super.create();
        this.setTitle("Image importing options");
        this.setMessage(String.valueOf(Messages.ImageImportingDialog_DefaultMessage) + Messages.ImageImportingDialog_AbsPathMessage, 0);
        this.getButton(0).setEnabled(false);
    }

    private void setEnableAbsImagePath(boolean enable) {
        this.absPathChoosingButton.setSelection(enable);
        this.absPathText.setEnabled(enable);
    }

    private void setEnableRelativeImagePath(boolean enable) {
        this.relativePathChoosingButton.setSelection(enable);
        this.relativePathText.setEnabled(enable);
    }
}

