/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.tools.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.platform.sirius.ui.project.internal.CapellaProjectContentsLocationArea;
import org.polarsys.capella.core.platform.sirius.ui.project.internal.ProjectContentsLocationArea;

public class FilteringProjectContentsLocationArea
extends CapellaProjectContentsLocationArea {
    public FilteringProjectContentsLocationArea(ProjectContentsLocationArea.IErrorMessageReporter reporter, Composite composite) {
        super(reporter, composite);
    }

    public String checkValidLocation() {
        IProject project;
        String isValid = super.checkValidLocation();
        if (isValid == null && (project = this.getSelectedProject()) != null) {
            String selectedPrjloc = project.getLocation().toOSString();
            String trgtPrjLoc = this.getProjectLocation();
            if (trgtPrjLoc.startsWith(selectedPrjloc)) {
                return "Generation is not allowed inside the source project";
            }
        }
        return isValid;
    }

    private IProject getSelectedProject() {
        ISelection sel;
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        Object selectedObject = sel = selectionService.getSelection("capella.project.explorer");
        if (sel instanceof IStructuredSelection) {
            selectedObject = ((IStructuredSelection)sel).getFirstElement();
            if (selectedObject instanceof EObject) {
                return EcoreUtil2.getProject((EObject)((EObject)selectedObject));
            }
            if (selectedObject instanceof IAdaptable) {
                IResource res = (IResource)((IAdaptable)selectedObject).getAdapter(IResource.class);
                return res.getProject();
            }
        }
        return null;
    }
}

