/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.tools;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.BundleContext;
import org.polarsys.capella.common.ui.services.AbstractUIActivator;
import org.polarsys.capella.filtering.FilteringCriterion;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;
import org.polarsys.capella.filtering.tools.view.GlobalFiteringCache;
import org.polarsys.kitalpha.ad.common.utils.URIFix;

public class FilteringToolsPlugin
extends AbstractUIActivator {
    public static final String ID = "org.polarsys.capella.filtering.tools";
    public static final String FILTERING_ODESIGN = "/org.polarsys.capella.filtering.sirius.analysis/description/FilteringResults.odesign";
    public static final URI FILTER_URI = URIFix.createPlatformPluginURI((String)"/org.polarsys.capella.filtering.sirius.analysis/description/FilteringResults.odesign#//@ownedViewpoints[name='Filtering']/@ownedRepresentations[name='Filtering']/@filters[name='VisibleDiagramFilteringCriteria']", (boolean)false);
    private static FilteringToolsPlugin plugin;
    private Map<ImageDescriptor, Image> descriptorsToImages;
    private static Map<FilteringCriterion, Collection<?>> implicitImpactCache;
    private static GlobalFiteringCache globalFilteringCache;

    static {
        implicitImpactCache = new HashMap();
        globalFilteringCache = new GlobalFiteringCache();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.descriptorsToImages = new HashMap<ImageDescriptor, Image>();
        plugin = this;
        FilteringToolsPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("FEATURES_DIAGRAM") || event.getProperty().equals("OPTIONAL_DIAGRAM") || event.getProperty().equals("SAVE_DECORATORS_DIAGRAM")) {
                    FilteringUtils.forceRefreshAllDiagrams();
                }
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        for (Image img : this.descriptorsToImages.values()) {
            if (img == null) continue;
            img.dispose();
        }
        plugin = null;
        super.stop(context);
    }

    public static FilteringToolsPlugin getDefault() {
        return plugin;
    }

    public static Map<FilteringCriterion, Collection<?>> getImplicitImpactCache() {
        return implicitImpactCache;
    }

    public static GlobalFiteringCache getGlobalFilteringCache() {
        return globalFilteringCache;
    }

    public Image getImage(ImageDescriptor desc) {
        if (!this.descriptorsToImages.containsKey(desc)) {
            this.descriptorsToImages.put(desc, desc.createImage());
        }
        return this.descriptorsToImages.get(desc);
    }
}

