/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.tests.ju.tests.misc;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.commandline.core.CommandLineException;
import org.polarsys.capella.core.validation.commandline.DerivationCommandLine;
import org.polarsys.capella.test.commandline.ju.utils.MockApplicationContext;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.api.ModelProviderHelper;
import org.polarsys.capella.test.framework.helpers.GuiActions;
import org.polarsys.capella.test.framework.helpers.IFileRequestor;
import org.polarsys.capella.test.framework.helpers.IResourceHelpers;

public class DerivationCommandLineTest
extends BasicTestCase {
    private static String INPUT_PROJECT_NAME = "derivationProject";
    private static String FILTERING_RESULT_ID = "4e535130-528c-49ff-b27e-69833f15f395";
    private static String FILTERING_RESULT_NAME = "FilteringResult 1";
    private static String DERIVATION_PROJECT_NAME = "DerivationProjectName";
    private static String APP_ID = "org.polarsys.capella.filtering.commandline";

    public void test() throws Exception {
        File inputProjectFolder = this.getFolderInTestModelRepository(INPUT_PROJECT_NAME);
        ModelProviderHelper.getInstance().importCapellaProject(INPUT_PROJECT_NAME, inputProjectFolder);
        this.assertProjectDerivationDefaultName();
        this.assertProjectDerivationCustomName();
    }

    private void assertProjectDerivationDefaultName() {
        String[] commandLineArguments = new String[]{"-appid", APP_ID, "-input", INPUT_PROJECT_NAME, "-filteringresultid", FILTERING_RESULT_ID};
        this.runDerivationCommandLine(commandLineArguments);
        IProject derivedProject = IResourceHelpers.getEclipseProjectInWorkspace((String)FILTERING_RESULT_NAME);
        this.assertDerivedProject(derivedProject);
        this.runDerivationCommandLine(commandLineArguments);
        derivedProject = IResourceHelpers.getEclipseProjectInWorkspace((String)(String.valueOf(FILTERING_RESULT_NAME) + "_2"));
        this.assertDerivedProject(derivedProject);
    }

    private void assertProjectDerivationCustomName() {
        String[] commandLineArguments = new String[]{"-appid", APP_ID, "-input", INPUT_PROJECT_NAME, "-filteringresultid", FILTERING_RESULT_ID, "-derivationprojectname", DERIVATION_PROJECT_NAME};
        this.runDerivationCommandLine(commandLineArguments);
        IProject derivedProject = IResourceHelpers.getEclipseProjectInWorkspace((String)DERIVATION_PROJECT_NAME);
        this.assertDerivedProject(derivedProject);
        this.runDerivationCommandLine(commandLineArguments);
        derivedProject = IResourceHelpers.getEclipseProjectInWorkspace((String)(String.valueOf(DERIVATION_PROJECT_NAME) + "_2"));
        this.assertDerivedProject(derivedProject);
    }

    private void runDerivationCommandLine(String[] commandLineArguments) {
        MockApplicationContext mockApplicationContext = new MockApplicationContext(commandLineArguments);
        DerivationCommandLine derivationCommandLine = new DerivationCommandLine();
        try {
            derivationCommandLine.parseContext((IApplicationContext)mockApplicationContext);
            derivationCommandLine.checkArgs((IApplicationContext)mockApplicationContext);
            derivationCommandLine.prepare((IApplicationContext)mockApplicationContext);
            derivationCommandLine.execute((IApplicationContext)mockApplicationContext);
        }
        catch (CommandLineException e) {
            DerivationCommandLineTest.fail((String)e.getMessage());
        }
    }

    protected Session getSession(IProject project) {
        IFile airdFile = (IFile)new IFileRequestor().search((IContainer)project, "aird").get(0);
        return SessionManager.INSTANCE.getSession(EcoreUtil2.getURI((IFile)airdFile), (IProgressMonitor)new NullProgressMonitor());
    }

    protected void assertDerivedProject(IProject project) {
        DerivationCommandLineTest.assertTrue((boolean)project.exists());
        Session session = this.getSession(project);
        DerivationCommandLineTest.assertTrue((session != null ? 1 : 0) != 0);
        session.open((IProgressMonitor)new NullProgressMonitor());
        GuiActions.closeSession((Session)session);
    }
}

