/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.tests.ju.tests.derivation;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.diffmerge.diffdata.impl.EComparisonImpl;
import org.eclipse.emf.diffmerge.generic.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.generic.api.scopes.IEditableTreeDataScope;
import org.eclipse.emf.diffmerge.generic.api.scopes.ITreeDataScope;
import org.eclipse.emf.diffmerge.impl.policies.DefaultMatchPolicy;
import org.eclipse.emf.diffmerge.impl.scopes.FragmentedModelScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.filtering.AbstractFilteringResult;
import org.polarsys.capella.filtering.FilteringCriterionSet;
import org.polarsys.capella.filtering.FilteringResults;
import org.polarsys.capella.filtering.tests.ju.tests.helpers.FilteringTestHelper;
import org.polarsys.capella.filtering.tools.actions.FilteringExtractionJob;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.helpers.IResourceHelpers;
import org.polarsys.capella.test.framework.helpers.TestHelper;

public class DerivationTest
extends BasicTestCase {
    private IProgressMonitor progressMonitor = new NullProgressMonitor();
    Session session = null;
    IProject project = null;
    AbstractFilteringResult currentFilteringResult = null;
    private String modelId;

    public List<String> getRequiredTestModels() {
        return Arrays.asList("MyLib", "sysmodel", "sysmodel_S_FR1", "sysmodel_S_FR2", "sysmodel_S_Empty_FR", "TestLib", "TestLib_DieselFilteringResult", "TestLib_HybridFilteringResult", "TestLib_PetrolFilteringResult", "TestSPLProject", "TestSPLProject_EmptyFilteringResult", "TestSPLProject_FilteringResult");
    }

    public List<String> getModelsUnderTest() {
        return Arrays.asList("sysmodel", "TestLib", "TestSPLProject");
    }

    private String getReferenceModelName(String originalModelName, String filteringResultName) {
        return String.valueOf(originalModelName) + "_" + filteringResultName;
    }

    public void test() {
        try {
            this.doTestDerivation();
        }
        catch (Exception exception) {
            throw new WrappedException(this.getInfoOfCurrentTest(), exception);
        }
    }

    public void doTestDerivation() throws Exception {
        for (String inputModelName : this.getModelsUnderTest()) {
            this.performDerivationAndCheck(inputModelName);
        }
    }

    private void performDerivationAndCheck(String inputModelName) throws Exception {
        this.project = IResourceHelpers.getEclipseProjectInWorkspace((String)inputModelName);
        Session session = this.getSessionForTestModel(inputModelName);
        session.open(this.progressMonitor);
        FilteringResults FilteringResults2 = FilteringTestHelper.getFilteringResults(session.getSemanticResources());
        Iterator iterator = FilteringResults2.getFilteringResults().iterator();
        while (iterator.hasNext()) {
            AbstractFilteringResult filterResult;
            this.currentFilteringResult = filterResult = (AbstractFilteringResult)iterator.next();
            System.err.println("=== currentFilteringResult: " + this.currentFilteringResult);
            IProject expectedResultProject = IResourceHelpers.getEclipseProjectInWorkspace((String)filterResult.getName());
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            String derivedProjectName = filterResult.getName();
            IProject derivedProject = workspace.getRoot().getProject(derivedProjectName);
            derivedProject.create(this.progressMonitor);
            derivedProject.open(this.progressMonitor);
            FilteringCriterionSet computedFilteringCriterionSet = filterResult.computeFilteringCriterionSet();
            if (computedFilteringCriterionSet == null) {
                DerivationTest.fail((String)(String.valueOf(this.getInfoOfCurrentTest()) + "Filtering result is empty! (computed filtering criterion set is empty)"));
            }
            FilteringExtractionJob job = new FilteringExtractionJob(this.project, derivedProject, (List)computedFilteringCriterionSet.getFilteringCriteria(), filterResult, this.modelId);
            workspace.run((IWorkspaceRunnable)job, this.progressMonitor);
            IFile derivedAirdFile = DerivationTest.findFirstMatchingFile("aird", (IResource)derivedProject);
            Session sessionOfDerived = TestHelper.openOrGetSession((IFile)derivedAirdFile);
            sessionOfDerived.open(this.progressMonitor);
            DerivationTest.assertTrue((String)("Session of derived project does not open!: " + this.getInfoOfCurrentTest()), (boolean)sessionOfDerived.isOpen());
            String refModelName = this.getReferenceModelName(inputModelName, filterResult.getName());
            Session expectedResultSession = this.getSessionForTestModel(refModelName);
            expectedResultSession.open(this.progressMonitor);
            DerivationTest.assertTrue((String)("Session of expected project does not open!: " + this.getInfoOfCurrentTest()), (boolean)expectedResultSession.isOpen());
            this.checkProjectsHaveSameNatures(this.project, derivedProject);
            this.checkProjectsHaveSameNatures(expectedResultProject, derivedProject);
            this.checkProjectsContainSameIResources((IContainer)expectedResultProject, (IContainer)derivedProject);
            this.checkReferencedSemanticResources(expectedResultSession, sessionOfDerived);
            this.checkSemanticResourcesAreEqual(TestHelper.getSemanticResource((Session)expectedResultSession), TestHelper.getSemanticResource((Session)sessionOfDerived));
            sessionOfDerived.save(this.progressMonitor);
            sessionOfDerived.close(this.progressMonitor);
            derivedProject.close(this.progressMonitor);
            derivedProject.delete(5, this.progressMonitor);
        }
    }

    public void checkReferencedSemanticResources(Session expectedResultSession, Session sessionOfDerived) {
        Collection expectedSemanticResources = expectedResultSession.getSemanticResources();
        Collection derivedSemanticResources = sessionOfDerived.getSemanticResources();
        Set<IPath> expectedSemanticResourcesSet = this.getResourceRelativePaths(expectedSemanticResources);
        Set<IPath> derivedSemanticResourceSet = this.getResourceRelativePaths(derivedSemanticResources);
        DerivationTest.assertEquals((String)"Sessions do not have the same semantic resources list", expectedSemanticResourcesSet, derivedSemanticResourceSet);
    }

    private String getInfoOfCurrentTest() {
        return "Project=[" + this.project.getName() + "] with FilteringResult=[" + this.currentFilteringResult.getName() + "]";
    }

    public static IFile findFirstMatchingFile(final String fileExtension, IResource root) throws CoreException {
        final AtomicReference result = new AtomicReference();
        IResource scope = root != null ? root : ResourcesPlugin.getWorkspace().getRoot();
        scope.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) {
                if (result.get() != null) {
                    return false;
                }
                if (resource.getType() == 1) {
                    if (fileExtension == null) {
                        if (((IFile)resource).getFileExtension() == null) {
                            result.set((IFile)resource);
                        }
                    } else if (fileExtension.equals(((IFile)resource).getFileExtension())) {
                        result.set((IFile)resource);
                    }
                }
                return true;
            }
        });
        return (IFile)result.get();
    }

    public void checkSemanticResourcesAreEqual(Resource expectedResource, Resource derivedResource) throws InterruptedException, IOException, CoreException {
        FragmentedModelScope targetScope = new FragmentedModelScope(derivedResource, true);
        FragmentedModelScope referenceScope = new FragmentedModelScope(expectedResource, true);
        EComparisonImpl comparison = new EComparisonImpl((IEditableTreeDataScope)targetScope, (IEditableTreeDataScope)referenceScope);
        comparison.compute((IMatchPolicy)new TestCaseMatchPolicy(), null, null, this.progressMonitor);
        if (comparison.getNbDifferences() != 0) {
            DerivationTest.fail((String)(String.valueOf(this.getInfoOfCurrentTest()) + " expected derivation result failed."));
        }
    }

    public void checkProjectsHaveSameNatures(IProject project1, IProject project2) throws CoreException {
        String[] naturesProject1 = project1.getDescription().getNatureIds();
        String[] naturesProject2 = project2.getDescription().getNatureIds();
        HashSet<String> naturesProject1Set = new HashSet<String>(Arrays.asList(naturesProject1));
        HashSet<String> naturesProject2Set = new HashSet<String>(Arrays.asList(naturesProject2));
        DerivationTest.assertEquals((String)"Projects do not have the same nature(s)", naturesProject1Set, naturesProject2Set);
    }

    public void checkProjectsContainSameIResources(IContainer container1, IContainer container2) throws CoreException {
        IResource[] project1Members = container1.members();
        IResource[] project2Members = container2.members();
        Set<IPath> project1MembersPaths = this.getProjectRelativePaths(project1Members);
        Set<IPath> project2MembersPaths = this.getProjectRelativePaths(project2Members);
        DerivationTest.assertEquals((String)"Projects do not have same content", project1MembersPaths, project2MembersPaths);
        IResource[] iResourceArray = project1Members;
        int n = project1Members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource project1IResource = iResourceArray[n2];
            if (project1IResource instanceof IContainer) {
                IResource project2Resource = container2.findMember(project1IResource.getName());
                this.checkProjectsContainSameIResources((IContainer)project1IResource, (IContainer)project2Resource);
            }
            ++n2;
        }
    }

    public Set<IPath> getProjectRelativePaths(IResource[] projectMembers) {
        HashSet<IPath> relativePaths = new HashSet<IPath>();
        IResource[] iResourceArray = projectMembers;
        int n = projectMembers.length;
        int n2 = 0;
        while (n2 < n) {
            IResource iResource = iResourceArray[n2];
            relativePaths.add(iResource.getProjectRelativePath());
            ++n2;
        }
        return relativePaths;
    }

    public Set<IPath> getResourceRelativePaths(Collection<Resource> resources) {
        HashSet<IPath> resourceRelativePaths = new HashSet<IPath>();
        for (Resource r : resources) {
            resourceRelativePaths.add(WorkspaceSynchronizer.getFile((Resource)r).getProjectRelativePath());
        }
        return resourceRelativePaths;
    }

    private class TestCaseMatchPolicy
    extends DefaultMatchPolicy {
        private TestCaseMatchPolicy() {
        }

        public Object getMatchID(EObject element, ITreeDataScope<EObject> scope) {
            if (element instanceof Project) {
                return ((Project)element).getName();
            }
            return super.getMatchID(element, scope);
        }
    }
}

