/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.tools.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.ReloadingPolicy;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetSync;
import org.eclipse.swt.widgets.Display;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.AbstractNonDirtyingCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.model.handler.helpers.CrossReferencerHelper;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;
import org.polarsys.capella.core.sirius.ui.actions.DesignerControlAction;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.filtering.AbstractFilteringResult;
import org.polarsys.capella.filtering.AssociatedFilteringCriterionSet;
import org.polarsys.capella.filtering.FilteringCriterion;
import org.polarsys.capella.filtering.FilteringModel;
import org.polarsys.capella.filtering.tools.extract.FilteringExtractor;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;

public class FilteringExtractionJob
implements IWorkspaceRunnable {
    String domainId;
    IProject clonedProject;
    IProject currentProject;
    EObject configuration;
    List<FilteringCriterion> selectedFeatures;
    ExecutionManager executionManager = null;
    TransactionalEditingDomain editingDomain = null;
    ArrayList<Resource> resourcesToDelete = new ArrayList();
    Collection<String> selectedFeaturesFullLabels;

    public FilteringExtractionJob(IProject currentProject, IProject clonedProject, List<FilteringCriterion> selectedFeatures, AbstractFilteringResult filteringResult, String domainId) {
        this.domainId = domainId;
        this.currentProject = currentProject;
        this.clonedProject = clonedProject;
        this.selectedFeatures = selectedFeatures;
        this.configuration = filteringResult;
        this.selectedFeaturesFullLabels = this.computeSelectedFeatureFullLabels(selectedFeatures);
    }

    private Set<String> computeSelectedFeatureFullLabels(List<FilteringCriterion> selectedFeatures) {
        return selectedFeatures.parallelStream().filter(ModelElement.class::isInstance).map(ModelElement::getFullLabel).map(this::removeProjectAndSysEngPaths).collect(Collectors.toSet());
    }

    private String removeProjectAndSysEngPaths(String fullLabel) {
        return FilteringExtractionJob.removeFirst2Segments(fullLabel);
    }

    private static String removeFirst2Segments(String fullLabel) {
        String separator = "/";
        if (fullLabel == null) {
            return null;
        }
        int indexOfThirdOccurenceOfSeparator = fullLabel.indexOf(separator, fullLabel.indexOf(separator, fullLabel.indexOf(separator) + 1) + 1);
        String result = fullLabel.substring(indexOfThirdOccurenceOfSeparator);
        return result;
    }

    public void run(IProgressMonitor monitor) {
        try {
            try {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Derivation of:", (int)12);
                subMonitor.setTaskName("Performing derivation. Please wait...");
                subMonitor.subTask("Derivation of:" + this.currentProject.getName());
                subMonitor.split(1);
                FilteringExtractor extractor = new FilteringExtractor(this.clonedProject, this.domainId);
                extractor.cloneProjectNature(this.currentProject);
                subMonitor.split(1);
                subMonitor.subTask("Copying files");
                Map<String, String> oldReferenceToNewReference = extractor.cloneModels(this.currentProject);
                subMonitor.split(1);
                subMonitor.subTask("Updating references");
                extractor.updateReferences(oldReferenceToNewReference);
                subMonitor.split(1);
                List<IFile> airdModels = FilteringUtils.getAirdModels(this.clonedProject);
                subMonitor.setWorkRemaining(airdModels.size() * 20);
                for (IFile aird : airdModels) {
                    subMonitor.subTask("Opening session of new project");
                    Session session = FilteringUtils.openSession(aird, (IProgressMonitor)subMonitor.split(4));
                    session.setReloadingPolicy(new ReloadingPolicy(){

                        public List<ReloadingPolicy.Action> getActions(Session session, Resource resource, ResourceSetSync.ResourceStatus newStatus) {
                            return new ArrayList<ReloadingPolicy.Action>();
                        }
                    });
                    subMonitor.subTask("Preparing feature information");
                    subMonitor.split(2);
                    this.editingDomain = session.getTransactionalEditingDomain();
                    this.executionManager = ExecutionManagerRegistry.getInstance().getExecutionManager((EditingDomain)this.editingDomain);
                    Collection resources = session.getSemanticResources();
                    List<Resource> referencedLibraries = FilteringUtils.getReferencedLibraries(session);
                    for (Resource semanticResource : resources) {
                        CapellaDeleteCommand capellaDeleteCommand;
                        if (referencedLibraries.contains(semanticResource)) continue;
                        HashMap<FilteringCriterion, FilteringCriterion> mappingTable = new HashMap<FilteringCriterion, FilteringCriterion>();
                        boolean projectFound = false;
                        boolean systemEngineeringFound = false;
                        List<FilteringModel> derivedFilteringModels = null;
                        List<FilteringCriterion> newFeatures = Collections.emptyList();
                        IModel currentModel = null;
                        TreeIterator iterator = semanticResource.getAllContents();
                        while (iterator.hasNext()) {
                            final EObject current = (EObject)iterator.next();
                            if (current instanceof SystemEngineering) {
                                this.executionManager.execute((ICommand)new AbstractNonDirtyingCommand(){

                                    public void run() {
                                        ((SystemEngineering)current).setName(FilteringExtractionJob.this.clonedProject.getName());
                                    }
                                });
                                systemEngineeringFound = true;
                            }
                            if (current instanceof Project) {
                                currentModel = ILibraryManager.INSTANCE.getModel(current);
                                this.executionManager.execute((ICommand)new AbstractNonDirtyingCommand(){

                                    public void run() {
                                        ((Project)current).setName(FilteringExtractionJob.this.clonedProject.getName());
                                    }
                                });
                                List<FilteringModel> list = FilteringUtils.getFilteringModels(this.configuration, true);
                                derivedFilteringModels = FilteringUtils.getFilteringModels(current, true);
                                if (FilteringUtils.hasFilteringFeatures(list) && FilteringUtils.hasFilteringFeatures(derivedFilteringModels)) {
                                    List<FilteringCriterion> oldFeatures = FilteringUtils.getOwnedFilteringCriteria(list);
                                    newFeatures = FilteringUtils.getOwnedFilteringCriteria(derivedFilteringModels);
                                    this.mapFeatures(newFeatures, oldFeatures, mappingTable);
                                }
                                projectFound = true;
                            }
                            if (projectFound && systemEngineeringFound) break;
                        }
                        subMonitor.subTask("Calculating elements for removal");
                        subMonitor.split(1);
                        HashSet<EObject> elementsToDelete = new HashSet<EObject>();
                        ArrayList<EObject> elementsToUncontrol = new ArrayList<EObject>();
                        if (derivedFilteringModels != null) {
                            for (Object t : newFeatures) {
                                final FilteringCriterion filteringCriterion = (FilteringCriterion)t;
                                if (this.selectedFeatures.contains(mappingTable.get(filteringCriterion))) continue;
                                List referencingElements = CrossReferencerHelper.getReferencingElements((EObject)filteringCriterion);
                                for (EObject eObject : referencingElements) {
                                    EObject eContainer = eObject.eContainer();
                                    if (!(eObject instanceof AssociatedFilteringCriterionSet) || !(eContainer instanceof CapellaElement)) continue;
                                    final CapellaElement capellaElement = (CapellaElement)eContainer;
                                    IModel model = ILibraryManager.INSTANCE.getModel((EObject)capellaElement);
                                    if (currentModel == null || !currentModel.equals(model) || this.isAlreadyContained(elementsToDelete, (EObject)capellaElement)) continue;
                                    if (!this.hasOneCheckedFeature(capellaElement, mappingTable)) {
                                        elementsToDelete.add((EObject)capellaElement);
                                    }
                                    this.executionManager.execute((ICommand)new AbstractNonDirtyingCommand(){

                                        public void run() {
                                            FilteringUtils.removeAssociatedCriteria((EObject)capellaElement, Collections.singletonList(filteringCriterion));
                                        }
                                    });
                                }
                                Set<EObject> impactedElements = FilteringUtils.getImpactedElements(elementsToDelete);
                                for (EObject element : impactedElements) {
                                    IModel model = ILibraryManager.INSTANCE.getModel(element);
                                    if (currentModel == null || !currentModel.equals(model)) continue;
                                    elementsToDelete.add(element);
                                }
                                for (EObject element : elementsToDelete) {
                                    if (!this.editingDomain.isControllable((Object)element) || !AdapterFactoryEditingDomain.isControlled((Object)element) || elementsToUncontrol.contains(element)) continue;
                                    elementsToUncontrol.add(element);
                                }
                            }
                        }
                        subMonitor.subTask("Preparation of fragment:");
                        subMonitor.split(1);
                        for (EObject eObject : elementsToUncontrol) {
                            this.performUncontrol(eObject);
                        }
                        if ((elementsToDelete = new HashSet(EcoreUtil.filterDescendants(elementsToDelete))).isEmpty() || !(capellaDeleteCommand = new CapellaDeleteCommand(this.executionManager, elementsToDelete, true, false, true){

                            public Collection<?> getAffectedObjects() {
                                Set allElementsToDelete = this.getAllElementsToDelete();
                                if (allElementsToDelete == null) {
                                    return Collections.emptySet();
                                }
                                return allElementsToDelete;
                            }
                        }).canExecute()) continue;
                        this.doExecuteNonDirtyingCommand((Command)capellaDeleteCommand);
                    }
                    subMonitor.subTask("Refreshing existing diagrams");
                    subMonitor.split(8);
                    FilteringUtils.refreshAllRepresentations(session, this.executionManager);
                    subMonitor.subTask("Saving and closing session");
                    session.save((IProgressMonitor)subMonitor.split(3));
                    SessionHelper.closeUiSessions(Collections.singletonList(this.clonedProject));
                    this.clonedProject.refreshLocal(2, (IProgressMonitor)subMonitor.split(1));
                }
            }
            catch (IOException | CoreException e) {
                e.printStackTrace();
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void doExecuteNonDirtyingCommand(final Command realCommand) {
        this.executionManager.execute((ICommand)new AbstractNonDirtyingCommand(){

            public void run() {
                realCommand.execute();
            }

            public Collection<?> getAffectedObjects() {
                Collection affectedObjects = realCommand.getAffectedObjects();
                if (affectedObjects == null) {
                    return Collections.emptyList();
                }
                return affectedObjects;
            }
        });
    }

    @Deprecated
    boolean isAlreadyContained(Set<EObject> elements, EObject current) {
        if (!elements.contains(current)) {
            for (EObject elts : elements) {
                TreeIterator iterator = elts.eAllContents();
                while (iterator.hasNext()) {
                    EObject elt = (EObject)iterator.next();
                    if (!elt.equals(current)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private void mapFeatures(List<FilteringCriterion> newFeatures, List<FilteringCriterion> oldFeatures, Map<FilteringCriterion, FilteringCriterion> mappingTable) {
        assert (oldFeatures.size() == newFeatures.size());
        for (FilteringCriterion newElement : newFeatures) {
            for (FilteringCriterion oldElement : oldFeatures) {
                String oldFeatureLabel;
                if (!(newElement instanceof FilteringCriterion) || !(oldElement instanceof FilteringCriterion)) continue;
                FilteringCriterion newFeature = newElement;
                FilteringCriterion oldFeature = oldElement;
                String newFeatureLabel = FilteringExtractionJob.removeFirst2Segments(newFeature.getFullLabel());
                if (!newFeatureLabel.equals(oldFeatureLabel = FilteringExtractionJob.removeFirst2Segments(oldFeature.getFullLabel()))) continue;
                mappingTable.put(newFeature, oldFeature);
            }
        }
    }

    private boolean hasOneCheckedFeature(CapellaElement elem, Map<FilteringCriterion, FilteringCriterion> mappingTable) {
        List<FilteringCriterion> associatedCriteria = FilteringUtils.getAssociatedCriteria((EObject)elem);
        for (FilteringCriterion associatedFeature : associatedCriteria) {
            if (!this.selectedFeatures.contains(mappingTable.get(associatedFeature))) continue;
            return true;
        }
        return false;
    }

    public void performUncontrol(EObject semanticRoot) {
        DesignerControlAction dca;
        DesignerControlAction designerControlAction = dca = new DesignerControlAction();
        designerControlAction.getClass();
        DesignerControlAction.CapellaSiriusUncontrolCommand vuc = new DesignerControlAction.CapellaSiriusUncontrolCommand(designerControlAction, semanticRoot, true);
        this.setResourceSetSyncNotificationEnabled(false);
        try {
            this.doExecuteNonDirtyingCommand((Command)vuc);
        }
        catch (Throwable throwable) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FilteringExtractionJob.this.setResourceSetSyncNotificationEnabled(true);
                }
            });
            throw throwable;
        }
        Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
    }

    public void setResourceSetSyncNotificationEnabled(boolean notificationEnabled) {
        if (this.editingDomain != null) {
            ResourceSetSync.getOrInstallResourceSetSync((TransactionalEditingDomain)this.editingDomain).setNotificationIsRequired(notificationEnabled);
        }
    }
}

