/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.tools.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryLabelProvider;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.platform.sirius.ui.project.internal.CapellaProjectContentsLocationArea;
import org.polarsys.capella.core.platform.sirius.ui.project.internal.ProjectContentsLocationArea;
import org.polarsys.capella.core.platform.sirius.ui.project.internal.WizardNewProjectCreationPage;
import org.polarsys.capella.core.platform.sirius.ui.project.operations.ProjectSessionCreationHelper;
import org.polarsys.capella.filtering.ComposedFilteringResult;
import org.polarsys.capella.filtering.FilteringCriterion;
import org.polarsys.capella.filtering.tools.actions.IFilteringProjectWizard;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;
import org.polarsys.capella.filtering.tools.utils.ui.FilteringResultsContentProvider;

class ComposedFilteringProjectWizard
extends BasicNewResourceWizard
implements IFilteringProjectWizard {
    protected IProject currentProject;
    protected IProject clonedProject;
    protected ComposedFilteringResult selectedComposedResult;
    private ContainerCheckedTreeViewer viewer;
    private WizardNewProjectCreationPage localProjectDescriptionPage;
    private static final Logger logger = ReportManagerRegistry.getInstance().subscribe("User Interface");

    ComposedFilteringProjectWizard(IProject project, ComposedFilteringResult result) {
        this.currentProject = project;
        this.selectedComposedResult = result;
    }

    @Override
    public IProject getResult() {
        return this.clonedProject;
    }

    public ComposedFilteringResult getSelectedComposedResult() {
        return this.selectedComposedResult;
    }

    public void addPages() {
        this.localProjectDescriptionPage = this.createLocalProjectDescriptionPage();
        this.addPage((IWizardPage)this.localProjectDescriptionPage);
    }

    @Override
    public List<FilteringCriterion> getSelectedFeatures() {
        return Collections.emptyList();
    }

    protected WizardNewProjectCreationPage createLocalProjectDescriptionPage() {
        WizardNewProjectCreationPage mainPage = new WizardNewProjectCreationPage("MelodyProjNewPage"){

            protected ProjectContentsLocationArea handleDefaultProjectLocation(Composite parent) {
                return new CapellaProjectContentsLocationArea(this.getErrorReporter(), parent);
            }

            protected void createProjectApproachGroup(Composite parent) {
                Group featureSelectionGroup = new Group(parent, 0);
                featureSelectionGroup.setLayoutData((Object)new GridData(4, 4, true, true));
                featureSelectionGroup.setLayout((Layout)new GridLayout());
                featureSelectionGroup.setText("Composed Filtering Result that is going to be used for derivation");
                ComposedFilteringProjectWizard.this.createTreeViewer(featureSelectionGroup);
            }

            protected boolean validatePage() {
                boolean validationResult = false;
                try {
                    validationResult = super.validatePage();
                }
                catch (Exception e) {
                    validationResult = false;
                }
                return validationResult;
            }
        };
        String newProjectName = this.selectedComposedResult.getName();
        mainPage.setInitialProjectName(newProjectName);
        int i = 2;
        while (FilteringUtils.resourceExists((IResource)mainPage.getProjectHandle())) {
            newProjectName = String.valueOf(this.selectedComposedResult.getName()) + "_" + i;
            mainPage.setInitialProjectName(newProjectName);
            ++i;
        }
        mainPage.setDescription("Derive a new Capella project.");
        mainPage.setTitle("Capella Project");
        return mainPage;
    }

    protected void createTreeViewer(Group featureSelectionGroup) {
        this.viewer = new ContainerCheckedTreeViewer((Composite)featureSelectionGroup, 2048);
        Tree tree = this.viewer.getTree();
        this.viewer.setAutoExpandLevel(-1);
        tree.setEnabled(false);
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.viewer.getTree().setBackground(Display.getCurrent().getSystemColor(22));
        this.viewer.setContentProvider((IContentProvider)new FilteringResultsContentProvider());
        Session session = SessionManager.INSTANCE.getSession((EObject)this.selectedComposedResult);
        TransactionalEditingDomain transactionalEditingDomain = session.getTransactionalEditingDomain();
        TransactionalAdapterFactoryLabelProvider labelProvider = new TransactionalAdapterFactoryLabelProvider(transactionalEditingDomain, ((AdapterFactoryEditingDomain)transactionalEditingDomain).getAdapterFactory());
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setComparator(new ViewerComparator());
        this.viewer.setInput((Object)this.selectedComposedResult);
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IPath newPath;
                    IPath defaultPath = Platform.getLocation();
                    if (defaultPath.equals((Object)(newPath = ComposedFilteringProjectWizard.this.localProjectDescriptionPage.getLocationPath()))) {
                        newPath = null;
                    }
                    List referencedProjects = Collections.emptyList();
                    ProjectSessionCreationHelper helper = new ProjectSessionCreationHelper(true, true, CapellaProjectHelper.ProjectApproach.SingletonComponents);
                    ComposedFilteringProjectWizard.this.clonedProject = helper.createNewEclipseProject(ComposedFilteringProjectWizard.this.localProjectDescriptionPage.getProjectName(), newPath, referencedProjects, monitor);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            logger.error((Object)exception);
            return false;
        }
        if (!FilteringUtils.resourceExists((IResource)this.clonedProject)) {
            this.clonedProject = null;
            return false;
        }
        return true;
    }
}

