/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.diffmerge.defer.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.generic.api.scopes.IEditableTreeDataScope;
import org.eclipse.emf.diffmerge.ui.setup.EMFDiffMergeEditorInput;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonMethod;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonMethodFactory;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinition;
import org.eclipse.emf.diffmerge.ui.util.MiscUtil;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.ui.IEditorInput;
import org.polarsys.capella.diffmerge.defer.helpers.DeferComparisonOperation;
import org.polarsys.capella.diffmerge.defer.ui.DeferComparisonHandler;
import org.polarsys.capella.diffmerge.defer.ui.EMFDiffMergeDeferUIPlugin;

public class DeferComparisonJob
extends Job {
    protected final EMFDiffNode diffNode;
    protected final URI deferFileURI;
    protected DeferComparisonOperation deferOperation;

    public DeferComparisonJob(EMFDiffNode node, URI deferFileURI) {
        super("");
        this.diffNode = node;
        this.deferFileURI = deferFileURI;
        this.deferOperation = null;
        this.setUser(true);
    }

    public DeferComparisonOperation createDeferComparisonOperation(EMFDiffNode node, URI deferFileURI) {
        IEditorInput ei;
        DeferComparisonOperation result = null;
        IEditableTreeDataScope targetScope = node.getUIComparison().getActualComparison().getScope(DeferComparisonHandler.TARGET_ROLE);
        Object firstRoot = targetScope.getRoots().get(0);
        EditingDomain ed = AdapterFactoryEditingDomain.getEditingDomainFor(firstRoot);
        if (ed != null && (ei = node.getEditorInput()) instanceof EMFDiffMergeEditorInput) {
            IModelScopeDefinition scopeDef;
            Object entrypoint;
            IComparisonMethodFactory factory;
            IComparisonMethod method = ((EMFDiffMergeEditorInput)ei).getComparisonMethod();
            IComparisonMethodFactory iComparisonMethodFactory = factory = method == null ? null : method.getFactory();
            if (method != null && factory != null && (entrypoint = (scopeDef = method.getModelScopeDefinition(DeferComparisonHandler.TARGET_ROLE)).getEntrypoint()) instanceof URI) {
                result = this.createDeferComparisonOperation((EComparison)node.getActualComparison(), ed.getResourceSet(), deferFileURI, (URI)entrypoint, factory.getID());
            }
        }
        return result;
    }

    protected DeferComparisonOperation createDeferComparisonOperation(EComparison comparison, ResourceSet resourceSet, URI changeResourceURI, URI targetScopeURI, String comparisonMethodFactoryID) {
        return new DeferComparisonOperation(comparison, resourceSet, changeResourceURI, targetScopeURI, comparisonMethodFactoryID);
    }

    public DeferComparisonOperation getDeferOperation() {
        return this.deferOperation;
    }

    protected IStatus run(final IProgressMonitor monitor) {
        final IStatus[] result = new IStatus[1];
        this.deferOperation = this.createDeferComparisonOperation(this.diffNode, this.deferFileURI);
        if (this.deferOperation != null) {
            this.setName(this.deferOperation.getOperationName());
            Runnable behavior = new Runnable(){

                @Override
                public void run() {
                    result[0] = DeferComparisonJob.this.deferOperation.run(monitor);
                }
            };
            try {
                MiscUtil.execute((EditingDomain)this.diffNode.getEditingDomain(), (String)this.getName(), (Runnable)behavior, (boolean)false);
            }
            catch (Exception e) {
                result[0] = new Status(4, EMFDiffMergeDeferUIPlugin.getDefault().getPluginId(), e.getMessage(), (Throwable)e);
            }
        } else {
            result[0] = new Status(4, EMFDiffMergeDeferUIPlugin.getDefault().getPluginId(), "Cannot initialize operation");
        }
        return result[0];
    }
}

