/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.validation.design.consistency;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.FunctionalExchangeExt;
import org.polarsys.capella.core.model.utils.NamingHelper;
import org.polarsys.capella.cybersecurity.model.ThreatSourceUse;

public class CY_DCON_05_ThreatSourceUse_Exchange
extends AbstractModelConstraint {
    private final String CE_OTHER = "Component Exchange";
    private final String CE_OA = "Communication Mean";
    private final String FE_OTHER = "Functional Exchange";
    private final String FE_OA = "Interaction";
    private final String PL_OA = "";
    private final String PL_OTHER = "/Physical Link";

    public IStatus validate(IValidationContext ctx) {
        ThreatSourceUse threatSourceUse = (ThreatSourceUse)ctx.getTarget();
        Component source = threatSourceUse.getThreatSource();
        BlockArchitecture bla = BlockArchitectureExt.getRootBlockArchitecture((EObject)source);
        Component usedActor = threatSourceUse.getUsed();
        List sourceComponents = ComponentExt.getAllSubUsedAndDeployedComponents((Component)source);
        List targetComponents = ComponentExt.getAllSubUsedAndDeployedComponents((Component)usedActor);
        for (Component componentSource : sourceComponents) {
            for (Component componentTarget : targetComponents) {
                if (!this.existsRelationBetweenThem(componentSource, componentTarget)) continue;
                return ctx.createSuccessStatus();
            }
        }
        if (bla instanceof OperationalAnalysis) {
            return ctx.createFailureStatus(new Object[]{threatSourceUse, NamingHelper.getTitleLabel((EObject)threatSourceUse), "Communication Mean", "Interaction", ""});
        }
        return ctx.createFailureStatus(new Object[]{threatSourceUse, NamingHelper.getTitleLabel((EObject)threatSourceUse), "Component Exchange", "Functional Exchange", "/Physical Link"});
    }

    private boolean existsRelationBetweenThem(Component comp1, Component comp2) {
        return this.existsCEBetweenComponents(comp1, comp2) || this.existsFEBetweenComponents(comp1, comp2) || this.existsPLBetweenComponents(comp1, comp2);
    }

    private boolean existsFEBetweenComponents(Component comp1, Component comp2) {
        BlockArchitecture bla = BlockArchitectureExt.getRootBlockArchitecture((EObject)comp1);
        EList usedActorFunctions = comp1.getAllocatedFunctions();
        for (AbstractFunction function : comp2.getAllocatedFunctions()) {
            for (FunctionalExchange fe : FunctionExt.getAllExchanges((AbstractFunction)function)) {
                AbstractFunction target;
                AbstractFunction source;
                if (bla instanceof OperationalAnalysis) {
                    source = FunctionalExchangeExt.getSourceFunction((FunctionalExchange)fe);
                    target = FunctionalExchangeExt.getTargetFunction((FunctionalExchange)fe);
                } else {
                    source = fe.getSource().eContainer();
                    target = fe.getSource().eContainer();
                }
                if (!usedActorFunctions.contains((Object)source) && !usedActorFunctions.contains((Object)target)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean existsPLBetweenComponents(Component comp1, Component comp2) {
        BlockArchitecture bla = BlockArchitectureExt.getRootBlockArchitecture((EObject)comp1);
        Set componentsInvolvedInPLs = PhysicalLinkExt.getAllRelatedPhysicalLinks((Component)comp1).stream().flatMap(x -> {
            Component target;
            Component source;
            if (bla instanceof OperationalAnalysis) {
                source = PhysicalLinkExt.getSourceComponent((PhysicalLink)x);
                target = PhysicalLinkExt.getTargetComponent((PhysicalLink)x);
            } else {
                source = x.getSourcePhysicalPort().eContainer();
                target = x.getTargetPhysicalPort().eContainer();
            }
            return Stream.of(source, target);
        }).collect(Collectors.toSet());
        return componentsInvolvedInPLs.contains(comp2);
    }

    private boolean existsCEBetweenComponents(Component comp1, Component comp2) {
        BlockArchitecture bla = BlockArchitectureExt.getRootBlockArchitecture((EObject)comp1);
        Set componentsInvolvedInCEs = ComponentExt.getAllRelatedComponentExchange((Component)comp1).stream().flatMap(x -> {
            Component target;
            Component source;
            if (bla instanceof OperationalAnalysis) {
                source = ComponentExchangeExt.getSourceComponent((ComponentExchange)x);
                target = ComponentExchangeExt.getTargetComponent((ComponentExchange)x);
            } else {
                source = x.getSource().eContainer();
                target = x.getTarget().eContainer();
            }
            return Stream.of(source, target);
        }).collect(Collectors.toSet());
        return componentsInvolvedInCEs.contains(comp2);
    }
}

