/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.common;

import java.util.Arrays;
import java.util.Collection;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.FaFactory;

public class FunctionAllocator {
    private final Collection<? extends AbstractFunction> allocations;

    FunctionAllocator(Collection<? extends AbstractFunction> eia) {
        this.allocations = eia;
    }

    public FunctionAllocator on(Component c) {
        for (AbstractFunction abstractFunction : this.allocations) {
            if (!abstractFunction.getAllocationBlocks().isEmpty()) continue;
            ComponentFunctionalAllocation cfa = FaFactory.eINSTANCE.createComponentFunctionalAllocation();
            cfa.setSourceElement((TraceableElement)c);
            cfa.setTargetElement((TraceableElement)abstractFunction);
            c.getOwnedFunctionalAllocation().add((Object)cfa);
        }
        return this;
    }

    public static FunctionAllocator allocate(Collection<? extends AbstractFunction> functs) {
        return new FunctionAllocator(functs);
    }

    public static FunctionAllocator allocate(AbstractFunction ... abstractFunctions) {
        return new FunctionAllocator(Arrays.asList(abstractFunctions));
    }
}

