/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.config;

import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DNode;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyLiteral;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyType;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.cybersecurity.model.CybersecurityConfiguration;
import org.polarsys.capella.cybersecurity.model.CybersecurityQueries;
import org.polarsys.capella.cybersecurity.model.Threat;
import org.polarsys.capella.cybersecurity.sirius.analysis.CybersecurityServices;
import org.polarsys.capella.cybersecurity.test.config.CybersecurityConfigProject;
import org.polarsys.capella.cybersecurity.test.diagram.ThreatDiagram;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;

public class ThreatKindConfigTest
extends CybersecurityConfigProject {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        Project project = SessionHelper.getCapellaProject((Session)session);
        ViewpointManager manager = ViewpointManager.getInstance((ResourceSet)session.getTransactionalEditingDomain().getResourceSet());
        manager.activate("org.polarsys.capella.cybersecurity");
        CybersecurityConfiguration cyberConfig = CybersecurityQueries.getCybersecurityConfiguration((Project)project);
        ThreatKindConfigTest.assertNotNull((Object)cyberConfig);
        ThreatDiagram td = ThreatDiagram.createDiagram(context, "16953dc7-be25-45ef-9da9-32869d0cb53f");
        DNode threat = td.createThreat();
        EnumerationPropertyType threatKindType = CybersecurityQueries.getThreatKindPropertyType((Project)project);
        CybersecurityServices service = new CybersecurityServices();
        Threat threatElement = (Threat)threat.getTarget();
        EnumerationPropertyLiteral kindDefault = threatElement.getKind();
        ThreatKindConfigTest.assertEquals((String)kindDefault.getName(), (String)this.threatKinds[0]);
        ThreatKindConfigTest.assertEquals((String)service.getThreatLabel(threatElement), (String)(String.valueOf(threatElement.getName()) + "\n(" + this.threatKinds[0].toUpperCase() + ")"));
        this.updateThreatKind(threatElement, (EnumerationPropertyLiteral)threatKindType.getOwnedLiterals().get(1), project);
        ThreatKindConfigTest.assertEquals((String)threatElement.getKind().getName(), (String)this.threatKinds[1]);
        ThreatKindConfigTest.assertEquals((String)service.getThreatLabel(threatElement), (String)(String.valueOf(threatElement.getName()) + "\n(" + this.threatKinds[1].toUpperCase() + ")"));
        this.removeLiteralType(threatKindType, project, 0);
        ThreatKindConfigTest.assertEquals((String)threatElement.getKind().getName(), (String)this.threatKinds[1]);
        ThreatKindConfigTest.assertEquals((String)service.getThreatLabel(threatElement), (String)(String.valueOf(threatElement.getName()) + "\n(" + this.threatKinds[1].toUpperCase() + ")"));
        this.removeLiteralType(threatKindType, project, 0);
        ThreatKindConfigTest.assertNull((Object)threatElement.getKind());
        ThreatKindConfigTest.assertEquals((String)service.getThreatLabel(threatElement), (String)(String.valueOf(threatElement.getName()) + "\n(UNDEFINED)"));
        ThreatKindConfigTest.assertTrue((threatKindType.getOwnedLiterals().size() == 4 ? 1 : 0) != 0);
        this.updateThreatKind(threatElement, (EnumerationPropertyLiteral)threatKindType.getOwnedLiterals().get(2), project);
        ThreatKindConfigTest.assertEquals((String)threatElement.getKind().getName(), (String)this.threatKinds[4]);
        ThreatKindConfigTest.assertEquals((String)service.getThreatLabel(threatElement), (String)(String.valueOf(threatElement.getName()) + "\n(" + this.threatKinds[4].toUpperCase() + ")"));
        this.removeAllLiteralTypes(threatKindType, project);
        ThreatKindConfigTest.assertEquals((String)service.getThreatLabel(threatElement), (String)(String.valueOf(threatElement.getName()) + "\n(UNDEFINED)"));
        this.removePropertyType(threatKindType, project);
        ThreatKindConfigTest.assertEquals((String)service.getThreatLabel(threatElement), (String)(String.valueOf(threatElement.getName()) + "\n(UNDEFINED)"));
    }
}

