/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.ui.contribution.migration;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyLiteral;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyType;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.data.migration.contribution.AbstractMigrationContribution;
import org.polarsys.capella.cybersecurity.CyberSecurityViewpointHelper;
import org.polarsys.capella.cybersecurity.model.CybersecurityConfiguration;
import org.polarsys.capella.cybersecurity.model.CybersecurityQueries;
import org.polarsys.capella.cybersecurity.model.SecurityNeeds;
import org.polarsys.capella.cybersecurity.model.Threat;
import org.polarsys.capella.cybersecurity.model.activator.CybersecurityModelActivator;

public class CybersecurityMigrationContribution
extends AbstractMigrationContribution {
    Map<String, String> savedValues = new HashMap<String, String>();
    private CybersecurityConfiguration config;

    public void unaryMigrationExecute(EObject currentElement, MigrationContext context) {
        if (this.config != null && currentElement instanceof Threat) {
            this.threatMigration((Threat)currentElement);
        }
        if (this.config != null && currentElement instanceof SecurityNeeds) {
            this.securityNeedsMigration((SecurityNeeds)currentElement);
        }
    }

    public void unaryStartMigrationExecute(ExecutionManager executionManager, Resource resource, MigrationContext context) {
        EList ct;
        if (context.getResource().getName().contains(".afm") && !(ct = resource.getContents()).isEmpty() && CyberSecurityViewpointHelper.isViewpointActive((EObject)ct.get(0))) {
            this.config = new CybersecurityModelActivator().createCybersecurityConfiguration();
        }
    }

    public void unaryEndMigrationExecute(ExecutionManager executionManager, Resource resource, MigrationContext context) {
        Project project;
        if (this.config != null && !resource.getContents().isEmpty() && resource.getContents().get(0) instanceof Project && CybersecurityQueries.getCybersecurityConfiguration((Project)(project = (Project)resource.getContents().get(0))) == null) {
            project.getOwnedExtensions().add((Object)this.config);
        }
    }

    public boolean ignoreUnknownFeature(String prefix, String name, boolean isElement, EObject peekObject, String value, XMLResource resource, MigrationContext context) {
        if (peekObject instanceof Threat && "threatKind".equals(name)) {
            this.savedValues.put(String.valueOf(((Threat)peekObject).getId()) + ":" + name, value);
            return true;
        }
        if (peekObject instanceof SecurityNeeds) {
            this.savedValues.put(String.valueOf(((SecurityNeeds)peekObject).getId()) + ":" + name, value);
            return true;
        }
        return false;
    }

    public void dispose(MigrationContext context) {
        this.savedValues.clear();
        this.config = null;
    }

    private void threatMigration(Threat threat) {
        EnumerationPropertyLiteral literal;
        String searchValue = this.savedValues.get(String.valueOf(threat.getId()) + ":threatKind");
        if (searchValue != null && searchValue.contains("THEFT")) {
            searchValue = "THEFT";
        }
        if ((literal = this.getLiteral(this.config.getThreatKind(), searchValue)) != null) {
            threat.setKind(literal);
        }
    }

    private void securityNeedsMigration(SecurityNeeds sn) {
        EnumerationPropertyLiteral literalC = this.getLiteral(this.config.getConfidentiality(), this.savedValues.get(String.valueOf(sn.getId()) + ":confidentiality"));
        EnumerationPropertyLiteral literalI = this.getLiteral(this.config.getIntegrity(), this.savedValues.get(String.valueOf(sn.getId()) + ":integrity"));
        EnumerationPropertyLiteral literalT = this.getLiteral(this.config.getTraceability(), this.savedValues.get(String.valueOf(sn.getId()) + ":traceability"));
        EnumerationPropertyLiteral literalA = this.getLiteral(this.config.getAvailability(), this.savedValues.get(String.valueOf(sn.getId()) + ":availability"));
        if (literalC != null) {
            sn.setConfidentialityValue(literalC);
        }
        if (literalI != null) {
            sn.setIntegrityValue(literalI);
        }
        if (literalT != null) {
            sn.setTraceabilityValue(literalT);
        }
        if (literalA != null) {
            sn.setAvailabilityValue(literalA);
        }
    }

    private EnumerationPropertyLiteral getLiteral(EnumerationPropertyType type, String value) {
        Optional<EnumerationPropertyLiteral> result;
        if (value != null && type != null && (result = type.getOwnedLiterals().stream().filter(literal -> literal.getName() != null && literal.getName().equalsIgnoreCase(value.replaceAll("_", " "))).findAny()).isPresent()) {
            return result.get();
        }
        return null;
    }
}

