/*******************************************************************************
 * Copyright (c) 2006, 2020 THALES GLOBAL SERVICES.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Thales - initial API and implementation
 *******************************************************************************/
package org.polarsys.capella.core.data.fa;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Function Realization</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.polarsys.capella.core.data.fa.FunctionRealization#getAllocatedFunction <em>Allocated Function</em>}</li>
 *   <li>{@link org.polarsys.capella.core.data.fa.FunctionRealization#getAllocatingFunction <em>Allocating Function</em>}</li>
 * </ul>
 *
 * @see org.polarsys.capella.core.data.fa.FaPackage#getFunctionRealization()
 * @model annotation="http://www.polarsys.org/kitalpha/ecore/documentation description='an allocation link between a function, and the function that it realizes\r\n[source: Capella study]' usage\040guideline='this link is typically generated by the Capella tool during automated transitions between design levels' used\040in\040levels='operational,system,logical,physical' usage\040examples='n/a' constraints='none' comment/notes='none' reference\040documentation='none'"
 *        annotation="http://www.polarsys.org/capella/MNoE/CapellaLike/Mapping UML/SysML\040semantic\040equivalences='' base\040metaclass\040in\040UML/SysML\040profile\040='uml::Realization' explanation='none' constraints='none'"
 * @generated
 */
public interface FunctionRealization extends AbstractFunctionAllocation {





	/**
	 * Returns the value of the '<em><b>Allocated Function</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.polarsys.capella.core.data.fa.AbstractFunction#getInFunctionRealizations <em>In Function Realizations</em>}'.

	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Allocated Function</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Allocated Function</em>' reference.
	 * @see org.polarsys.capella.core.data.fa.FaPackage#getFunctionRealization_AllocatedFunction()
	 * @see org.polarsys.capella.core.data.fa.AbstractFunction#getInFunctionRealizations
	 * @model opposite="inFunctionRealizations" required="true" transient="true" changeable="false" volatile="true" derived="true"
	 *        annotation="http://www.polarsys.org/capella/derived viatra.variant='alias' viatra.expression='targetElement'"
	 *        annotation="http://www.polarsys.org/kitalpha/ecore/documentation description='the function that is being allocated by/from the other function\r\n[source: Capella study]' constraints='none' comment/notes='none'"
	 *        annotation="http://www.polarsys.org/capella/MNoE/CapellaLike/Mapping UML/SysML\040semantic\040equivalences='keyword::none' explanation='Derived and transient' constraints='none'"
	 * @generated
	 */

	AbstractFunction getAllocatedFunction();







	/**
	 * Returns the value of the '<em><b>Allocating Function</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.polarsys.capella.core.data.fa.AbstractFunction#getOutFunctionRealizations <em>Out Function Realizations</em>}'.

	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Allocating Function</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Allocating Function</em>' reference.
	 * @see org.polarsys.capella.core.data.fa.FaPackage#getFunctionRealization_AllocatingFunction()
	 * @see org.polarsys.capella.core.data.fa.AbstractFunction#getOutFunctionRealizations
	 * @model opposite="outFunctionRealizations" required="true" transient="true" changeable="false" volatile="true" derived="true"
	 *        annotation="http://www.polarsys.org/capella/derived viatra.variant='alias' viatra.expression='sourceElement'"
	 *        annotation="http://www.polarsys.org/kitalpha/ecore/documentation description='the function that allocates (to) the other function\r\n[source: Capella study]' constraints='none' comment/notes='none'"
	 *        annotation="http://www.polarsys.org/capella/MNoE/CapellaLike/Mapping UML/SysML\040semantic\040equivalences='keyword::none' explanation='Derived and transient' constraints='none'"
	 * @generated
	 */

	AbstractFunction getAllocatingFunction();





} // FunctionRealization
