/*******************************************************************************
 * Copyright (c) 2006, 2020 THALES GLOBAL SERVICES.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Thales - initial API and implementation
 *******************************************************************************/

package org.polarsys.capella.core.platform.sirius.ui.commands;

import java.util.Collection;

/**
 */
public interface IDeleteCommandDelegation {
  /**
   * Allow to implement additional behavior at pre execution time of the {@link CapellaDeleteCommand}.<br>
   * This method is called at the beginning of {@link CapellaDeleteCommand#doExecute()}.
   * @param elementsToDelete
   * @return <code>null</code> means preExecute succeeds; otherwise an error message is returned.
   */
  public String preExecute(Collection<?> elementsToDelete);

}
