/*******************************************************************************
 * Copyright (c) 2006, 2020 THALES GLOBAL SERVICES.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Thales - initial API and implementation
 *******************************************************************************/
package org.polarsys.capella.core.data.core.properties.sections;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.core.properties.Messages;
import org.polarsys.capella.core.ui.properties.controllers.SimpleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.SimpleSemanticField;

/**
 * The EnumerationPropertyValue section.
 */
public class EnumerationPropertyValueSection extends NamedElementSection {

  private SimpleSemanticField _typeField;
  private SimpleSemanticField _valueField;

  /**
   * {@inheritDoc}
   */
  @Override
  public void createContents(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
    super.createContents(parent, aTabbedPropertySheetPage);

    boolean displayedInWizard = isDisplayedInWizard();

    _typeField = new SimpleSemanticField(getReferencesGroup(), Messages.getString("EnumerationPropertyValue.Type.Label"), getWidgetFactory(), new SimpleSemanticFieldController()); //$NON-NLS-1$
    _typeField.setDisplayedInWizard(displayedInWizard);

    _valueField = new SimpleSemanticField(getReferencesGroup(), Messages.getString("EnumerationPropertyValue.Value.Label"), getWidgetFactory(), new SimpleSemanticFieldController()); //$NON-NLS-1$
    _valueField.setDisplayedInWizard(displayedInWizard);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void loadData(EObject capellaElement) {
    super.loadData(capellaElement);

    _typeField.loadData(capellaElement, CapellacorePackage.eINSTANCE.getEnumerationPropertyValue_Type());
    _valueField.loadData(capellaElement, CapellacorePackage.eINSTANCE.getEnumerationPropertyValue_Value());
  }

  /**
   * @see org.eclipse.jface.viewers.IFilter#select(java.lang.Object)
   */
  @Override
  public boolean select(Object toTest) {
    EObject eObjectToTest = super.selection(toTest);
    return ((eObjectToTest != null) && (eObjectToTest.eClass() == CapellacorePackage.eINSTANCE.getEnumerationPropertyValue()));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<AbstractSemanticField> getSemanticFields() {
    List<AbstractSemanticField> fields = new ArrayList<AbstractSemanticField>();

    fields.addAll(super.getSemanticFields());
    fields.add(_typeField);
    fields.add(_valueField);

    return fields;
  }
}
