/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.semantic.queries.basic.queries.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.core.data.fa.AbstractFunctionalBlock;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.oa.CommunicationMean;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.EntityPkg;
import org.polarsys.capella.core.data.oa.OperationalActivity;

public class ConnectionsUtils {
    public static List<CommunicationMean> getRelatedCommunicationMeans(FunctionalExchange functionalExchange) {
        ArrayList<CommunicationMean> returnValue = new ArrayList<CommunicationMean>();
        ActivityNode source = functionalExchange.getSource();
        if (source instanceof OperationalActivity) {
            OperationalActivity oa = (OperationalActivity)source;
            EList allocationBlocks = oa.getAllocationBlocks();
            for (AbstractFunctionalBlock next : allocationBlocks) {
                if (!(next instanceof Entity)) continue;
                Entity entity = (Entity)next;
                List<CommunicationMean> outgoingCommunicationMeans = ConnectionsUtils.getOutgoingCommunicationMeans(entity);
                for (CommunicationMean commMean : outgoingCommunicationMeans) {
                    if (!commMean.getAllocatedFunctionalExchanges().contains((Object)functionalExchange)) continue;
                    returnValue.add(commMean);
                }
            }
        }
        return returnValue;
    }

    private static List<CommunicationMean> getOutgoingCommunicationMeans(Entity entity) {
        ArrayList<CommunicationMean> result = new ArrayList<CommunicationMean>();
        EObject container = entity.eContainer();
        while (container != null && !(container instanceof EntityPkg)) {
            container = entity.eContainer();
        }
        if (container != null) {
            EntityPkg entityPackage = (EntityPkg)container;
            TreeIterator allContents = entityPackage.eAllContents();
            while (allContents.hasNext()) {
                CommunicationMean comMean;
                EObject next = (EObject)allContents.next();
                if (!(next instanceof CommunicationMean) || (comMean = (CommunicationMean)next).getSource() != entity) continue;
                result.add(comMean);
            }
        }
        return result;
    }
}

