/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ColorManager
implements ISharedTextColors {
    private static ColorManager fgColorManager;
    protected Map<RGB, Color> fColorTable = new HashMap<RGB, Color>(10);

    private ColorManager() {
    }

    public static ColorManager getDefault() {
        if (fgColorManager == null) {
            fgColorManager = new ColorManager();
        }
        return fgColorManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Color getColor(RGB rgb) {
        Color color = this.fColorTable.get(rgb);
        if (color == null) {
            Map<RGB, Color> map = this.fColorTable;
            synchronized (map) {
                color = this.fColorTable.get(rgb);
                if (color == null) {
                    PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                        Color color = this.fColorTable.put(rgb, new Color((Device)Display.getCurrent(), rgb));
                    });
                    color = this.fColorTable.get(rgb);
                }
            }
        }
        return color;
    }

    public void dispose() {
        for (Color color : this.fColorTable.values()) {
            color.dispose();
        }
    }
}

