/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.debug.ui.launchConfigurations;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchTab;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JavaDebugImages;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.debug.ui.launcher.NameValuePairDialog;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class AppletParametersTab
extends JavaLaunchTab {
    private Text fWidthText;
    private Text fHeightText;
    private Text fNameText;
    private Button fParametersAddButton;
    private Button fParametersRemoveButton;
    private Button fParametersEditButton;
    private AppletTabListener fListener = new AppletTabListener();
    private static final String EMPTY_STRING = "";
    public static final int DEFAULT_APPLET_WIDTH = 200;
    public static final int DEFAULT_APPLET_HEIGHT = 200;
    private TableViewer fViewer;

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite((Composite)parent, (int)1, (int)1, (int)768);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_APPLET_PARAMETERS_TAB);
        Composite namecomp = SWTFactory.createComposite((Composite)comp, (Font)comp.getFont(), (int)4, (int)1, (int)768, (int)0, (int)0);
        SWTFactory.createLabel((Composite)namecomp, (String)LauncherMessages.appletlauncher_argumenttab_widthlabel_text, (int)1);
        this.fWidthText = SWTFactory.createSingleText((Composite)namecomp, (int)1);
        this.fWidthText.addModifyListener((ModifyListener)this.fListener);
        SWTFactory.createLabel((Composite)namecomp, (String)LauncherMessages.appletlauncher_argumenttab_namelabel_text, (int)1);
        this.fNameText = SWTFactory.createSingleText((Composite)namecomp, (int)1);
        this.fNameText.addModifyListener((ModifyListener)this.fListener);
        SWTFactory.createLabel((Composite)namecomp, (String)LauncherMessages.appletlauncher_argumenttab_heightlabel_text, (int)1);
        this.fHeightText = SWTFactory.createSingleText((Composite)namecomp, (int)1);
        this.fHeightText.addModifyListener((ModifyListener)this.fListener);
        Label blank = new Label(namecomp, 0);
        blank.setText(EMPTY_STRING);
        Label hint = SWTFactory.createLabel((Composite)namecomp, (String)LauncherMessages.AppletParametersTab__optional_applet_instance_name__1, (int)1);
        GridData gd = new GridData(64);
        hint.setLayoutData((Object)gd);
        SWTFactory.createVerticalSpacer((Composite)comp, (int)1);
        Composite paramcomp = SWTFactory.createComposite((Composite)comp, (Font)comp.getFont(), (int)2, (int)1, (int)1808, (int)0, (int)0);
        SWTFactory.createLabel((Composite)paramcomp, (String)LauncherMessages.appletlauncher_argumenttab_parameterslabel_text, (int)2);
        Table ptable = new Table(paramcomp, 67584);
        this.fViewer = new TableViewer(ptable);
        gd = new GridData(1808);
        ptable.setLayoutData((Object)gd);
        TableColumn column1 = new TableColumn(ptable, 0);
        column1.setText(LauncherMessages.appletlauncher_argumenttab_parameterscolumn_name_text);
        TableColumn column2 = new TableColumn(ptable, 0);
        column2.setText(LauncherMessages.appletlauncher_argumenttab_parameterscolumn_value_text);
        TableLayout tableLayout = new TableLayout();
        ptable.setLayout((Layout)tableLayout);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        ptable.setHeaderVisible(true);
        ptable.setLinesVisible(true);
        ptable.addSelectionListener((SelectionListener)this.fListener);
        ptable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                AppletParametersTab.this.setParametersButtonsEnableState();
                if (AppletParametersTab.this.fParametersEditButton.isEnabled()) {
                    AppletParametersTab.this.handleParametersEditButtonSelected();
                }
            }
        });
        this.fViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Map params = (Map)inputElement;
                return params.keySet().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return element.toString();
                }
                String key = (String)element;
                Map params = AppletParametersTab.this.getViewerInput();
                Object object = params.get(key);
                if (object != null) {
                    return object.toString();
                }
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.fViewer.setComparator(new ViewerComparator());
        Composite envcomp = SWTFactory.createComposite((Composite)paramcomp, (Font)paramcomp.getFont(), (int)1, (int)1, (int)258, (int)0, (int)0);
        this.fParametersAddButton = this.createPushButton(envcomp, LauncherMessages.appletlauncher_argumenttab_parameters_button_add_text, null);
        this.fParametersAddButton.addSelectionListener((SelectionListener)this.fListener);
        this.fParametersEditButton = this.createPushButton(envcomp, LauncherMessages.appletlauncher_argumenttab_parameters_button_edit_text, null);
        this.fParametersEditButton.addSelectionListener((SelectionListener)this.fListener);
        this.fParametersRemoveButton = this.createPushButton(envcomp, LauncherMessages.appletlauncher_argumenttab_parameters_button_remove_text, null);
        this.fParametersRemoveButton.addSelectionListener((SelectionListener)this.fListener);
        this.setParametersButtonsEnableState();
        Dialog.applyDialogFont((Control)parent);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        try {
            Integer.parseInt(this.getWidthText());
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(LauncherMessages.appletlauncher_argumenttab_width_error_notaninteger);
            return false;
        }
        try {
            Integer.parseInt(this.getHeightText());
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(LauncherMessages.appletlauncher_argumenttab_height_error_notaninteger);
            return false;
        }
        return true;
    }

    private void handleParametersAddButtonSelected() {
        NameValuePairDialog dialog = new NameValuePairDialog(this.getShell(), LauncherMessages.appletlauncher_argumenttab_parameters_dialog_add_title, new String[]{LauncherMessages.appletlauncher_argumenttab_parameters_dialog_add_name_text, LauncherMessages.appletlauncher_argumenttab_parameters_dialog_add_value_text}, new String[]{EMPTY_STRING, EMPTY_STRING});
        this.openNewParameterDialog(dialog, null);
        this.setParametersButtonsEnableState();
    }

    private void handleParametersEditButtonSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        String key = (String)selection.getFirstElement();
        Map<String, String> params = this.getViewerInput();
        String value = params.get(key);
        NameValuePairDialog dialog = new NameValuePairDialog(this.getShell(), LauncherMessages.appletlauncher_argumenttab_parameters_dialog_edit_title, new String[]{LauncherMessages.appletlauncher_argumenttab_parameters_dialog_edit_name_text, LauncherMessages.appletlauncher_argumenttab_parameters_dialog_edit_value_text}, new String[]{key, value});
        this.openNewParameterDialog(dialog, key);
    }

    private void handleParametersRemoveButtonSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object k = objectArray[n2];
            String key = (String)k;
            Map<String, String> params = this.getViewerInput();
            params.remove(key);
            ++n2;
        }
        this.fViewer.refresh();
        this.setParametersButtonsEnableState();
        this.updateLaunchConfigurationDialog();
    }

    private void setParametersButtonsEnableState() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        int selectCount = selection.size();
        if (selectCount < 1) {
            this.fParametersEditButton.setEnabled(false);
            this.fParametersRemoveButton.setEnabled(false);
        } else {
            this.fParametersRemoveButton.setEnabled(true);
            if (selectCount == 1) {
                this.fParametersEditButton.setEnabled(true);
            } else {
                this.fParametersEditButton.setEnabled(false);
            }
        }
        this.fParametersAddButton.setEnabled(true);
    }

    private void openNewParameterDialog(NameValuePairDialog dialog, String key) {
        if (dialog.open() != 0) {
            return;
        }
        String[] nameValuePair = dialog.getNameValuePair();
        Map<String, String> params = this.getViewerInput();
        params.remove(key);
        params.put(nameValuePair[0], nameValuePair[1]);
        this.fViewer.refresh();
        this.updateLaunchConfigurationDialog();
    }

    private Map<String, String> getViewerInput() {
        return (Map)this.fViewer.getInput();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        try {
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_WIDTH, Integer.parseInt(this.getWidthText()));
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_HEIGHT, Integer.parseInt(this.getHeightText()));
        }
        catch (NumberFormatException numberFormatException) {}
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_NAME, this.fNameText.getText());
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_PARAMETERS, this.getViewerInput());
    }

    private String getWidthText() {
        return this.fWidthText.getText().trim();
    }

    private String getHeightText() {
        return this.fHeightText.getText().trim();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    @Override
    public void initializeFrom(ILaunchConfiguration config) {
        try {
            this.fWidthText.setText(Integer.toString(config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_WIDTH, 200)));
        }
        catch (CoreException coreException) {
            this.fWidthText.setText(Integer.toString(200));
        }
        try {
            this.fHeightText.setText(Integer.toString(config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_HEIGHT, 200)));
        }
        catch (CoreException coreException) {
            this.fHeightText.setText(Integer.toString(200));
        }
        try {
            this.fNameText.setText(config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_NAME, LauncherMessages.appletlauncher_argumenttab_name_defaultvalue));
        }
        catch (CoreException coreException) {
            this.fNameText.setText(LauncherMessages.appletlauncher_argumenttab_name_defaultvalue);
        }
        HashMap input = new HashMap();
        try {
            Map params = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_PARAMETERS, null);
            if (params != null) {
                input.putAll(params);
            }
        }
        catch (CoreException coreException) {}
        this.fViewer.setInput(input);
    }

    public String getName() {
        return LauncherMessages.appletlauncher_argumenttab_name;
    }

    public String getId() {
        return "org.eclipse.jdt.debug.ui.appletParametersTab";
    }

    public Image getImage() {
        return JavaDebugImages.get("IMG_VIEW_ARGUMENTS_TAB");
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    private class AppletTabListener
    extends SelectionAdapter
    implements ModifyListener {
        private AppletTabListener() {
        }

        public void modifyText(ModifyEvent e) {
            AppletParametersTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == AppletParametersTab.this.fViewer.getTable() || source == AppletParametersTab.this.fViewer) {
                AppletParametersTab.this.setParametersButtonsEnableState();
            } else if (source == AppletParametersTab.this.fParametersAddButton) {
                AppletParametersTab.this.handleParametersAddButtonSelected();
            } else if (source == AppletParametersTab.this.fParametersEditButton) {
                AppletParametersTab.this.handleParametersEditButtonSelected();
            } else if (source == AppletParametersTab.this.fParametersRemoveButton) {
                AppletParametersTab.this.handleParametersRemoveButtonSelected();
            }
        }
    }
}

